/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tcc.handler;

import java.util.Optional;
import java.util.function.Supplier;
import org.aspectj.lang.ProceedingJoinPoint;
import org.dromara.hmily.annotation.TransTypeEnum;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.core.context.HmilyContextHolder;
import org.dromara.hmily.core.context.HmilyTransactionContext;
import org.dromara.hmily.core.disruptor.DisruptorConsumerFactory;
import org.dromara.hmily.core.disruptor.DisruptorProviderManage;
import org.dromara.hmily.core.disruptor.handler.HmilyTransactionExecutorHandler;
import org.dromara.hmily.core.holder.HmilyTransactionHolder;
import org.dromara.hmily.core.service.HmilyTransactionHandler;
import org.dromara.hmily.core.service.HmilyTransactionHandlerAlbum;
import org.dromara.hmily.metrics.enums.MetricsLabelEnum;
import org.dromara.hmily.metrics.spi.MetricsHandlerFacade;
import org.dromara.hmily.metrics.spi.MetricsHandlerFacadeEngine;
import org.dromara.hmily.repository.spi.entity.HmilyTransaction;
import org.dromara.hmily.tcc.executor.HmilyTccTransactionExecutor;

public class StarterHmilyTccTransactionHandler
implements HmilyTransactionHandler,
AutoCloseable {
    private final HmilyTccTransactionExecutor executor = HmilyTccTransactionExecutor.getInstance();
    private DisruptorProviderManage<HmilyTransactionHandlerAlbum> disruptorProviderManage = new DisruptorProviderManage((DisruptorConsumerFactory)new HmilyTransactionExecutorHandler(), Runtime.getRuntime().availableProcessors() << 1, DisruptorProviderManage.DEFAULT_SIZE.intValue());

    public StarterHmilyTccTransactionHandler() {
        this.disruptorProviderManage.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handler(ProceedingJoinPoint point, HmilyTransactionContext context) throws Throwable {
        Object returnValue;
        Supplier histogramSupplier = null;
        Optional handlerFacade = MetricsHandlerFacadeEngine.load();
        try {
            if (handlerFacade.isPresent()) {
                ((MetricsHandlerFacade)handlerFacade.get()).counterIncrement(MetricsLabelEnum.TRANSACTION_TOTAL.getName(), new String[]{TransTypeEnum.TCC.name()});
                histogramSupplier = ((MetricsHandlerFacade)handlerFacade.get()).histogramStartTimer(MetricsLabelEnum.TRANSACTION_LATENCY.getName(), new String[]{TransTypeEnum.TCC.name()});
            }
            HmilyTransaction hmilyTransaction = this.executor.preTry(point);
            try {
                returnValue = point.proceed();
                hmilyTransaction.setStatus(HmilyActionEnum.TRYING.getCode());
                this.executor.updateStartStatus(hmilyTransaction);
            }
            catch (Throwable throwable) {
                HmilyTransaction currentTransaction = HmilyTransactionHolder.getInstance().getCurrentTransaction();
                this.disruptorProviderManage.getProvider().onData(() -> {
                    handlerFacade.ifPresent(metricsHandlerFacade -> metricsHandlerFacade.counterIncrement(MetricsLabelEnum.TRANSACTION_STATUS.getName(), new String[]{TransTypeEnum.TCC.name(), HmilyRoleEnum.START.name(), HmilyActionEnum.CANCELING.name()}));
                    this.executor.globalCancel(currentTransaction);
                });
                throw throwable;
            }
            HmilyTransaction currentTransaction = HmilyTransactionHolder.getInstance().getCurrentTransaction();
            this.disruptorProviderManage.getProvider().onData(() -> {
                handlerFacade.ifPresent(metricsHandlerFacade -> metricsHandlerFacade.counterIncrement(MetricsLabelEnum.TRANSACTION_STATUS.getName(), new String[]{TransTypeEnum.TCC.name(), HmilyRoleEnum.START.name(), HmilyActionEnum.CONFIRMING.name()}));
                this.executor.globalConfirm(currentTransaction);
            });
        }
        finally {
            HmilyContextHolder.remove();
            this.executor.remove();
            if (null != histogramSupplier) {
                histogramSupplier.get();
            }
        }
        return returnValue;
    }

    @Override
    public void close() {
        this.disruptorProviderManage.getProvider().shutdown();
    }
}

