/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tcc.handler;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.dromara.hmily.annotation.TransTypeEnum;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.core.context.HmilyContextHolder;
import org.dromara.hmily.core.context.HmilyTransactionContext;
import org.dromara.hmily.core.disruptor.HmilyDisruptor;
import org.dromara.hmily.core.disruptor.HmilyDisruptorConsumer;
import org.dromara.hmily.core.disruptor.handler.HmilyTransactionEventConsumer;
import org.dromara.hmily.core.holder.HmilyTransactionHolder;
import org.dromara.hmily.core.service.HmilyTransactionHandler;
import org.dromara.hmily.core.service.HmilyTransactionTask;
import org.dromara.hmily.metrics.reporter.MetricsReporter;
import org.dromara.hmily.repository.spi.entity.HmilyTransaction;
import org.dromara.hmily.tcc.executor.HmilyTccTransactionExecutor;

public class StarterHmilyTccTransactionHandler
implements HmilyTransactionHandler,
AutoCloseable {
    private final HmilyTccTransactionExecutor executor = HmilyTccTransactionExecutor.getInstance();
    private HmilyDisruptor<HmilyTransactionTask> disruptor = new HmilyDisruptor((HmilyDisruptorConsumer)new HmilyTransactionEventConsumer(), Runtime.getRuntime().availableProcessors() << 1, HmilyDisruptor.DEFAULT_SIZE.intValue());

    public StarterHmilyTccTransactionHandler() {
        this.disruptor.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleTransaction(ProceedingJoinPoint point, HmilyTransactionContext context) throws Throwable {
        Object returnValue;
        MetricsReporter.counterIncrement((String)"hmily_transaction_total", (String[])new String[]{TransTypeEnum.TCC.name()});
        LocalDateTime starterTime = LocalDateTime.now();
        try {
            HmilyTransaction hmilyTransaction = this.executor.preTry(point);
            try {
                returnValue = point.proceed();
                hmilyTransaction.setStatus(HmilyActionEnum.TRYING.getCode());
                this.executor.updateStartStatus(hmilyTransaction);
            }
            catch (Throwable throwable) {
                HmilyTransaction currentTransaction = HmilyTransactionHolder.getInstance().getCurrentTransaction();
                this.disruptor.getProvider().onData(() -> {
                    MetricsReporter.counterIncrement((String)"hmily_transaction_status", (String[])new String[]{TransTypeEnum.TCC.name(), HmilyRoleEnum.START.name(), HmilyActionEnum.CANCELING.name()});
                    this.executor.globalCancel(currentTransaction);
                });
                throw throwable;
            }
            HmilyTransaction currentTransaction = HmilyTransactionHolder.getInstance().getCurrentTransaction();
            this.disruptor.getProvider().onData(() -> {
                MetricsReporter.counterIncrement((String)"hmily_transaction_status", (String[])new String[]{TransTypeEnum.TCC.name(), HmilyRoleEnum.START.name(), HmilyActionEnum.CONFIRMING.name()});
                this.executor.globalConfirm(currentTransaction);
            });
        }
        finally {
            HmilyContextHolder.remove();
            this.executor.remove();
            MetricsReporter.recordTime((String)"hmily_transaction_latency_histogram_millis", (long)starterTime.until(LocalDateTime.now(), ChronoUnit.MILLIS));
        }
        return returnValue;
    }

    @Override
    public void close() {
        this.disruptor.getProvider().shutdown();
    }

    static {
        MetricsReporter.registerCounter((String)"hmily_transaction_total", (String[])new String[]{"type"}, (String)"hmily transaction total count");
        MetricsReporter.registerHistogram((String)"hmily_transaction_latency_histogram_millis", (String)"hmily transaction Latency Histogram Millis (ms)");
    }
}

