/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.xa.core;

import java.rmi.RemoteException;
import java.time.LocalDateTime;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.dromara.hmily.xa.core.Finally;
import org.dromara.hmily.xa.core.Resource;
import org.dromara.hmily.xa.core.XaState;
import org.dromara.hmily.xa.core.XidImpl;
import org.dromara.hmily.xa.core.timer.HmilyTimer;
import org.dromara.hmily.xa.core.timer.TimerRemovalListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Coordinator
implements Resource,
Finally,
TimerRemovalListener<Resource> {
    private final Logger logger = LoggerFactory.getLogger(Coordinator.class);
    private final Vector<Resource> coordinators = new Vector();
    private final XidImpl xid;
    private XaState state = XaState.STATUS_ACTIVE;
    private final LocalDateTime date;
    private final HmilyTimer<Resource> hmilyTimer;
    private Boolean hasSuper;

    public Coordinator(XidImpl xid, boolean hasSuper) {
        this.xid = xid;
        this.date = LocalDateTime.now();
        this.hasSuper = hasSuper;
        this.hmilyTimer = new HmilyTimer(30000L, TimeUnit.SECONDS, xid.getGlobalId());
        this.hmilyTimer.addRemovalListener(this);
    }

    public HmilyTimer<Resource> getTimer() {
        return this.hmilyTimer;
    }

    @Override
    public Resource.Result prepare() {
        return this.doPrepare();
    }

    @Override
    public void rollback() throws RemoteException {
        switch (this.state) {
            case STATUS_ACTIVE: 
            case STATUS_MARKED_ROLLBACK: {
                this.logger.warn("statue == STATUS_ACTIVE OR STATUS_MARKED_ROLLBACK");
                break;
            }
            case STATUS_ROLLEDBACK: {
                this.logger.warn("statue == STATUS_ROLLED_BACK");
                return;
            }
        }
        this.doRollback();
    }

    @Override
    public void commit() throws RemoteException {
        switch (this.state) {
            case STATUS_ACTIVE: {
                break;
            }
            case STATUS_COMMITTED: {
                this.logger.warn("commit done");
                return;
            }
            case STATUS_ROLLEDBACK: {
                this.logger.warn("commit state == STATUS_ROLLEDBACK");
                throw new TransactionRolledbackException();
            }
            case STATUS_MARKED_ROLLBACK: {
                this.doRollback();
                throw new TransactionRolledbackException();
            }
            default: {
                throw new TransactionRequiredException("status error");
            }
        }
        if (this.coordinators.size() == 1) {
            this.state = XaState.STATUS_COMMITTING;
            Resource resource = this.coordinators.get(0);
            try {
                resource.onePhaseCommit();
                this.state = XaState.STATUS_COMMITTED;
            }
            catch (TransactionRolledbackException e) {
                this.state = XaState.STATUS_MARKED_ROLLBACK;
            }
            catch (Exception ex) {
                this.logger.error("onPhaseCommit error size to 1", (Throwable)ex);
                this.state = XaState.STATUS_UNKNOWN;
            }
            return;
        }
        Resource.Result result = this.doPrepare();
        if (result == Resource.Result.COMMIT) {
            this.doCommit();
        } else if (result == Resource.Result.READONLY) {
            this.doRollback();
        } else {
            this.state = XaState.STATUS_COMMITTED;
        }
    }

    @Override
    public void onePhaseCommit() throws RemoteException {
        this.logger.info("onePhaseCommit{}", (Object)this.xid);
        this.doCommit();
    }

    private Resource.Result doPrepare() {
        Resource.Result rs = Resource.Result.READONLY;
        if (this.coordinators.size() == 0) {
            this.state = XaState.STATUS_COMMITTED;
            return rs;
        }
        this.state = XaState.STATUS_PREPARING;
        int errors = 0;
        for (Resource coordinator : this.coordinators) {
            if (errors > 0) break;
            try {
                Resource.Result prepare = coordinator.prepare();
                if (prepare == Resource.Result.ROLLBACK) {
                    ++errors;
                    rs = Resource.Result.ROLLBACK;
                    continue;
                }
                if (prepare != Resource.Result.COMMIT) continue;
                rs = Resource.Result.COMMIT;
            }
            catch (Exception ex) {
                ++errors;
                rs = Resource.Result.ROLLBACK;
            }
        }
        if (rs == Resource.Result.COMMIT) {
            this.state = XaState.STATUS_PREPARED;
        } else if (rs == Resource.Result.READONLY) {
            this.state = XaState.STATUS_COMMITTED;
        }
        return rs;
    }

    public XaState getState() {
        return this.state;
    }

    public synchronized boolean addCoordinators(Resource resource) {
        if (this.coordinators.contains(resource)) {
            return true;
        }
        boolean add = this.coordinators.add(resource);
        if (add) {
            this.hmilyTimer.put(resource);
        }
        return add;
    }

    public void setRollbackOnly() {
        if (this.state == XaState.STATUS_ACTIVE) {
            this.state = XaState.STATUS_MARKED_ROLLBACK;
        }
    }

    private void doRollback() throws RemoteException {
        this.state = XaState.STATUS_ROLLEDBACK;
        for (Resource resource : this.coordinators) {
            if (resource == null) continue;
            resource.rollback();
        }
    }

    private void doCommit() throws TransactionRolledbackException {
        this.state = XaState.STATUS_COMMITTING;
        int commitErrors = 0;
        for (Resource resource : this.coordinators) {
            try {
                resource.commit();
            }
            catch (RemoteException e) {
                ++commitErrors;
            }
        }
        if (commitErrors != 0) {
            this.state = XaState.STATUS_ROLLEDBACK;
            throw new TransactionRolledbackException();
        }
        this.state = XaState.STATUS_COMMITTED;
    }

    @Override
    public void onRemoval(Resource value, Long expire, Long elapsed) {
    }
}

