/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.xa.core;

import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.dromara.hmily.core.context.HmilyContextHolder;
import org.dromara.hmily.core.context.HmilyTransactionContext;
import org.dromara.hmily.xa.core.TransactionImpl;
import org.dromara.hmily.xa.core.XaState;
import org.dromara.hmily.xa.core.XidImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmilyXaTransactionManager
implements TransactionManager {
    private final Logger logger = LoggerFactory.getLogger(HmilyXaTransactionManager.class);
    private final ThreadLocal<Stack<Transaction>> tms = new ThreadLocal();
    private final Map<String, Transaction> transactionMap = new ConcurrentHashMap<String, Transaction>();

    public static HmilyXaTransactionManager initialized() {
        return new HmilyXaTransactionManager();
    }

    public Transaction getTransaction() {
        return this.getThreadTransaction();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        boolean b;
        if (transaction == null) {
            this.clearTxTotr();
            return;
        }
        Transaction thm1 = this.getTransaction();
        if (thm1 != null) {
            if (thm1.equals(transaction)) {
                return;
            }
            this.logger.warn("The transaction of this thread is consistent with the one you passed in");
            throw new IllegalStateException("The transaction of this thread is consistent with the one you passed in");
        }
        boolean bl = b = !(transaction instanceof TransactionImpl);
        if (b) {
            throw new InvalidTransactionException("transaction not TransactionImpl");
        }
        TransactionImpl inTx = (TransactionImpl)transaction;
        XaState xaState = XaState.valueOf(inTx.getStatus());
        switch (xaState) {
            case STATUS_ACTIVE: 
            case STATUS_COMMITTING: 
            case STATUS_PREPARING: {
                break;
            }
            default: {
                throw new InvalidTransactionException("transaction state invalid");
            }
        }
        this.setTxTotr(transaction);
        try {
            inTx.doEnList(null, 0x8000000);
        }
        catch (RollbackException e) {
            throw new SystemException("RollbackException" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getThreadTransaction() {
        ThreadLocal<Stack<Transaction>> threadLocal = this.tms;
        synchronized (threadLocal) {
            Stack<Transaction> stack = this.tms.get();
            if (stack == null) {
                return null;
            }
            return stack.peek();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Transaction transaction = this.getTransaction();
        if (transaction == null) {
            throw new IllegalStateException("cannot get Transaction for setRollbackOnly");
        }
        transaction.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
    }

    public Transaction suspend() throws SystemException {
        Transaction transaction = this.getTransaction();
        if (transaction != null) {
            if (transaction instanceof TransactionImpl) {
                ((TransactionImpl)transaction).doDeList(0x2000000);
            }
            this.clearTxTotr();
        }
        return transaction;
    }

    public void begin() {
        Transaction threadTransaction;
        Transaction rct = threadTransaction = this.getThreadTransaction();
        if (threadTransaction != null) {
            TransactionImpl tx = (TransactionImpl)rct;
            rct = tx.createSubTransaction();
        } else {
            XidImpl xId;
            boolean hasSuper = false;
            HmilyTransactionContext context = HmilyContextHolder.get();
            if (context != null && context.getXaParticipant() != null) {
                xId = new XidImpl(context.getXaParticipant().getGlobalId(), context.getXaParticipant().getBranchId());
                hasSuper = true;
            } else {
                xId = new XidImpl();
            }
            rct = new TransactionImpl(xId, hasSuper);
            this.transactionMap.put(xId.getGlobalId(), rct);
        }
        this.setTxTotr(rct);
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Transaction threadTransaction = this.getThreadTransaction();
        if (threadTransaction == null) {
            throw new IllegalStateException("Transaction is null,can not commit");
        }
        try {
            threadTransaction.commit();
        }
        finally {
            this.clearTxTotr();
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        Transaction transaction = this.getTransaction();
        if (transaction == null) {
            throw new IllegalStateException("Transaction is null,can not rollback");
        }
        try {
            transaction.rollback();
        }
        finally {
            this.clearTxTotr();
        }
    }

    public int getStatus() throws SystemException {
        Transaction transaction = this.getTransaction();
        if (transaction == null) {
            throw new IllegalStateException("Transaction is null,can not getStatus");
        }
        return transaction.getStatus();
    }

    private boolean txCanRollback(Transaction transaction) throws SystemException {
        if (transaction.getStatus() == 1) {
            transaction.rollback();
            return true;
        }
        return false;
    }

    public Integer getState() throws SystemException {
        Transaction transaction = this.getTransaction();
        if (transaction == null) {
            return XaState.STATUS_NO_TRANSACTION.getState();
        }
        return transaction.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTxTotr() {
        ThreadLocal<Stack<Transaction>> threadLocal = this.tms;
        synchronized (threadLocal) {
            Stack<Transaction> stack = this.tms.get();
            Transaction pop = stack.pop();
            if (stack.empty()) {
                this.tms.remove();
                this.transactionMap.forEach((k, v) -> {
                    if (v == pop) {
                        this.transactionMap.remove(k);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTxTotr(Transaction transaction) {
        ThreadLocal<Stack<Transaction>> threadLocal = this.tms;
        synchronized (threadLocal) {
            Stack<Object> stack = this.tms.get();
            if (stack == null) {
                stack = new Stack();
                this.tms.set(stack);
            }
            stack.push(transaction);
        }
    }

    public void markTransactionRollback(String transId) {
        if (this.transactionMap.containsKey(transId)) {
            this.logger.warn("When rollback cmd is received, the business logic of transaction {} isn't stopped, maybe there is a RPC timout.", (Object)transId);
            try {
                this.transactionMap.get(transId).setRollbackOnly();
            }
            catch (SystemException e) {
                this.logger.error("err setRollbackOnly", (Throwable)e);
            }
        }
    }
}

