/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.xa.core;

import java.rmi.RemoteException;
import java.util.Objects;
import java.util.Optional;
import java.util.Vector;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.dromara.hmily.xa.core.HmilyXaException;
import org.dromara.hmily.xa.core.HmilyXaResource;
import org.dromara.hmily.xa.core.Resource;
import org.dromara.hmily.xa.core.TransactionImpl;
import org.dromara.hmily.xa.core.XaState;
import org.dromara.hmily.xa.core.XidImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubCoordinator
implements Resource {
    private final Logger logger = LoggerFactory.getLogger(SubCoordinator.class);
    private final TransactionImpl transaction;
    private XaState state = XaState.STATUS_ACTIVE;
    private final boolean hasSuper;
    private final Vector<XAResource> resources = new Vector();
    private final Vector<Synchronization> synchronizations = new Vector();

    public SubCoordinator(TransactionImpl transaction, boolean hasSuper) {
        this.transaction = transaction;
        this.hasSuper = hasSuper;
    }

    @Override
    public Resource.Result prepare() throws RemoteException {
        try {
            this.transaction.doDeList(0x4000000);
        }
        catch (Exception exception) {
            this.logger.error("do delist error", (Throwable)exception);
        }
        switch (this.state) {
            case STATUS_MARKED_ROLLBACK: {
                this.beforeCompletion();
                this.doRollback();
                return Resource.Result.ROLLBACK;
            }
            case STATUS_COMMITTED: {
                return Resource.Result.COMMIT;
            }
        }
        this.beforeCompletion();
        if (this.state == XaState.STATUS_MARKED_ROLLBACK) {
            this.doRollback();
            return Resource.Result.ROLLBACK;
        }
        Resource.Result result = this.doPrepare();
        if (result == Resource.Result.READONLY) {
            this.afterCompletion();
        }
        return result;
    }

    private synchronized Resource.Result doPrepare() {
        Resource.Result result = Resource.Result.READONLY;
        if (this.resources.size() == 0) {
            this.state = XaState.STATUS_COMMITTED;
            return result;
        }
        this.state = XaState.STATUS_PREPARING;
        boolean isError = false;
        for (int i = 0; i < this.resources.size(); ++i) {
            HmilyXaResource xaResource = (HmilyXaResource)this.resources.elementAt(i);
            if (isError) {
                try {
                    xaResource.rollback();
                }
                catch (XAException e) {
                    this.logger.error("call xa.rollback error {} ", (Object)HmilyXaException.getMessage(e));
                }
                continue;
            }
            try {
                int prepare = xaResource.prepare();
                switch (prepare) {
                    case 0: {
                        result = Resource.Result.COMMIT;
                        break;
                    }
                    case 3: {
                        result = Resource.Result.ROLLBACK;
                        break;
                    }
                }
                continue;
            }
            catch (XAException e) {
                result = Resource.Result.ROLLBACK;
                isError = true;
                this.logger.error("{}", (Object)HmilyXaException.getMessage(e));
            }
        }
        switch (result) {
            case ROLLBACK: {
                this.state = XaState.STATUS_ROLLING_BACK;
                break;
            }
            case COMMIT: {
                this.state = XaState.STATUS_PREPARED;
                break;
            }
            case READONLY: {
                this.state = XaState.STATUS_COMMITTED;
                break;
            }
        }
        return result;
    }

    @Override
    public void rollback() throws RemoteException {
        try {
            this.transaction.doDeList(0x4000000);
        }
        catch (SystemException e) {
            this.logger.error("rollback error", (Throwable)e);
            return;
        }
        switch (this.state) {
            case STATUS_MARKED_ROLLBACK: 
            case STATUS_ACTIVE: 
            case STATUS_ROLLING_BACK: 
            case STATUS_PREPARED: {
                break;
            }
            case STATUS_ROLLEDBACK: {
                this.logger.warn("state == STATUS_ROLLEDBACK");
                return;
            }
            default: {
                return;
            }
        }
        this.beforeCompletion();
        this.doRollback();
    }

    private synchronized void doRollback() throws RemoteException {
        this.state = XaState.STATUS_ROLLEDBACK;
        int rollbackError = 0;
        boolean heurcom = false;
        for (int i = 0; i < this.resources.size(); ++i) {
            HmilyXaResource xaResource = (HmilyXaResource)this.resources.elementAt(i);
            try {
                xaResource.rollback();
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("xa rollback{}", (Object)xaResource.getXid());
                continue;
            }
            catch (XAException e) {
                this.logger.error("rollback  error {}:{}", (Object)xaResource.getXid(), (Object)HmilyXaException.getMessage(e));
                ++rollbackError;
                if (e.errorCode == 7) {
                    heurcom = true;
                    continue;
                }
                this.logger.error("rollback error {}", (Object)e.getMessage(), (Object)e);
                this.afterCompletion();
                throw new RuntimeException(HmilyXaException.getMessage(e));
            }
        }
        if (!heurcom) {
            this.afterCompletion();
        }
        if (rollbackError > 0) {
            this.state = XaState.STATUS_UNKNOWN;
        }
        if (heurcom) {
            throw new RemoteException();
        }
    }

    private synchronized void doCommit() {
        this.state = XaState.STATUS_COMMITTING;
        int commitError = 0;
        for (int i = 0; i < this.resources.size(); ++i) {
            HmilyXaResource xaResource = (HmilyXaResource)this.resources.elementAt(i);
            try {
                xaResource.commit(false);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("xa commit{}", (Object)xaResource.getXid());
                continue;
            }
            catch (XAException e) {
                this.logger.error("rollback  error,{}:{}", (Object)xaResource.getXid(), (Object)HmilyXaException.getMessage(e));
                ++commitError;
            }
        }
        this.state = commitError > 0 ? XaState.STATUS_UNKNOWN : XaState.STATUS_COMMITTED;
        this.afterCompletion();
    }

    @Override
    public void commit() {
        if (this.state == XaState.STATUS_PREPARED) {
            this.doCommit();
            this.logger.info("commit: start");
        } else {
            this.logger.error("commit: bad status {}", (Object)this.state);
        }
    }

    @Override
    public void onePhaseCommit() throws TransactionRolledbackException, RemoteException {
        if (this.state == XaState.STATUS_ROLLEDBACK) {
            try {
                this.transaction.doDeList(0x4000000);
            }
            catch (SystemException e) {
                this.logger.error("error doDeList error", (Throwable)e);
                throw new TransactionRolledbackException(e.getMessage());
            }
        }
        if (this.state == XaState.STATUS_MARKED_ROLLBACK) {
            try {
                this.beforeCompletion();
                this.transaction.doDeList(0x4000000);
            }
            catch (SystemException e) {
                this.logger.error("error doDeList error", (Throwable)e);
            }
            this.doRollback();
            throw new TransactionRolledbackException();
        }
        if (this.state == XaState.STATUS_COMMITTED) {
            try {
                this.transaction.doDeList(0x4000000);
            }
            catch (SystemException e) {
                this.logger.error("error doDeList error", (Throwable)e);
            }
            return;
        }
        try {
            this.transaction.doDeList(0x4000000);
            this.beforeCompletion();
        }
        catch (SystemException e) {
            this.logger.error("deList xaResource:", (Throwable)e);
        }
        if (this.state == XaState.STATUS_MARKED_ROLLBACK) {
            this.doRollback();
            throw new TransactionRolledbackException();
        }
        if (this.resources.size() == 1) {
            this.doOnePhaseCommit();
            return;
        }
        Resource.Result result = this.doPrepare();
        if (result == Resource.Result.COMMIT) {
            this.doCommit();
        } else if (result == Resource.Result.READONLY) {
            this.afterCompletion();
        } else if (result == Resource.Result.ROLLBACK) {
            this.doRollback();
            throw new TransactionRolledbackException();
        }
    }

    private void doOnePhaseCommit() throws TransactionRolledbackException {
        this.state = XaState.STATUS_COMMITTING;
        HmilyXaResource xaResource = (HmilyXaResource)this.resources.get(0);
        try {
            xaResource.commit(true);
            this.state = XaState.STATUS_COMMITTED;
        }
        catch (XAException ex) {
            this.state = XaState.STATUS_UNKNOWN;
            this.logger.error("xa commit error{}:{}", (Object)xaResource, (Object)HmilyXaException.getMessage(ex));
            if (Objects.equals(ex.errorCode, 100)) {
                throw new TransactionRolledbackException("XAException:" + ex.getMessage());
            }
            throw new RuntimeException("XAException" + ex.getMessage());
        }
        finally {
            this.afterCompletion();
        }
    }

    public synchronized XidImpl nextXid(XidImpl xId) {
        return xId.newResId(this.resources.size() + 1);
    }

    public synchronized boolean addXaResource(XAResource xaResource) {
        switch (this.state) {
            case STATUS_MARKED_ROLLBACK: {
                break;
            }
            case STATUS_ACTIVE: {
                break;
            }
            default: {
                throw new RuntimeException("status == " + (Object)((Object)this.state));
            }
        }
        Optional<XAResource> isSame = this.resources.stream().filter(e -> {
            try {
                return e.isSameRM(xaResource);
            }
            catch (XAException xaException) {
                this.logger.error("xa isSameRM,{}:{}", (Object)xaException, (Object)HmilyXaException.getMessage(xaException));
                return false;
            }
        }).findFirst();
        if (!isSame.isPresent()) {
            this.resources.add(xaResource);
            return false;
        }
        return true;
    }

    public synchronized void addSynchronization(Synchronization synchronization) throws RollbackException {
        if (this.state == XaState.STATUS_ACTIVE) {
            this.synchronizations.add(synchronization);
            return;
        }
        if (this.state == XaState.STATUS_MARKED_ROLLBACK || this.state == XaState.STATUS_ROLLEDBACK) {
            this.synchronizations.add(synchronization);
            throw new RollbackException();
        }
    }

    public void setRollbackOnly() {
        if (this.state == XaState.STATUS_PREPARING) {
            this.state = XaState.STATUS_MARKED_ROLLBACK;
        }
    }

    public XaState getState() {
        return this.state;
    }

    private void beforeCompletion() {
        for (Synchronization synchronization : this.synchronizations) {
            synchronization.beforeCompletion();
        }
    }

    private void afterCompletion() {
        for (Synchronization synchronization : this.synchronizations) {
            synchronization.afterCompletion(this.state.getState().intValue());
        }
    }
}

