/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.xa.core;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.dromara.hmily.xa.core.Coordinator;
import org.dromara.hmily.xa.core.Finally;
import org.dromara.hmily.xa.core.HmilyXaException;
import org.dromara.hmily.xa.core.HmilyXaResource;
import org.dromara.hmily.xa.core.Resource;
import org.dromara.hmily.xa.core.SubCoordinator;
import org.dromara.hmily.xa.core.TransactionContext;
import org.dromara.hmily.xa.core.XaState;
import org.dromara.hmily.xa.core.XidImpl;
import org.dromara.hmily.xa.core.timer.TimerRemovalListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionImpl
implements Transaction,
TimerRemovalListener<Resource> {
    private final Logger logger = LoggerFactory.getLogger(TransactionImpl.class);
    private final XidImpl xid;
    private SubCoordinator subCoordinator;
    private final List<XAResource> enlistResourceList = Collections.synchronizedList(new ArrayList());
    private List<XAResource> delistResourceList;
    private final TransactionContext context;
    private final boolean hasSuper;

    TransactionImpl(XidImpl xId, boolean hasSuper) {
        this.xid = xId;
        this.hasSuper = hasSuper;
        this.context = new TransactionContext(null, xId);
        this.subCoordinator(true, true);
    }

    private TransactionImpl(TransactionImpl impl) {
        this.xid = impl.getXid().newBranchId();
        this.context = impl.getContext();
        this.delistResourceList = null;
        this.hasSuper = impl.hasSuper;
        this.subCoordinator(true, true);
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Finally oneFinally = this.context.getOneFinally();
        if (oneFinally != null) {
            try {
                if (this.getStatus() == XaState.STATUS_MARKED_ROLLBACK.getState().intValue()) {
                    oneFinally.rollback();
                } else if (this.hasSuper) {
                    this.doDeList(0x4000000);
                } else {
                    oneFinally.commit();
                }
            }
            catch (TransactionRolledbackException e) {
                this.logger.error("error rollback", (Throwable)e);
                throw new RollbackException();
            }
            catch (RemoteException e) {
                this.logger.error("error", (Throwable)e);
                throw new SystemException(e.getMessage());
            }
            return;
        }
        if (this.subCoordinator != null) {
            try {
                this.subCoordinator.onePhaseCommit();
            }
            catch (Exception e) {
                this.logger.error("onePhaseCommit()");
                throw new RollbackException();
            }
        }
    }

    public void doEnList(XAResource xaResource, int flag) throws SystemException, RollbackException {
        if (flag == 0x200000 || flag == 0) {
            this.enlistResource(xaResource);
        } else if (flag == 0x8000000 && this.delistResourceList != null) {
            for (XAResource resource : this.delistResourceList) {
                this.enlistResource(resource);
            }
        }
        this.delistResourceList = null;
    }

    public void doDeList(int flag) throws SystemException {
        this.delistResourceList = new ArrayList<XAResource>(this.enlistResourceList);
        for (XAResource resource : this.delistResourceList) {
            this.delistResource(resource, flag);
        }
    }

    public boolean delistResource(XAResource xaResource, int flag) throws IllegalStateException, SystemException {
        if (!this.enlistResourceList.contains(xaResource)) {
            return false;
        }
        HmilyXaResource myResoure = (HmilyXaResource)xaResource;
        try {
            myResoure.end(flag);
            this.enlistResourceList.remove(xaResource);
            return true;
        }
        catch (XAException e) {
            this.logger.info("xa resource end,{}", (Object)HmilyXaException.getMessage(e), (Object)e);
            return false;
        }
    }

    public boolean enlistResource(XAResource xaResource) throws RollbackException, IllegalStateException, SystemException {
        XidImpl resId;
        HmilyXaResource hmilyXaResource;
        boolean found;
        if (this.subCoordinator == null) {
            this.subCoordinator(false, false);
            if (this.subCoordinator == null) {
                throw new SystemException("not create subCoordinator");
            }
        }
        int flag = (found = this.subCoordinator.addXaResource(hmilyXaResource = new HmilyXaResource(resId = this.subCoordinator.nextXid(this.xid), xaResource))) ? 0x200000 : 0;
        try {
            if (this.delistResourceList != null && this.delistResourceList.contains(hmilyXaResource)) {
                flag = 0x8000000;
            }
            hmilyXaResource.start(flag);
        }
        catch (XAException e) {
            this.logger.error("{}", (Object)HmilyXaException.getMessage(e), (Object)e);
            throw new IllegalStateException(e);
        }
        if (!this.enlistResourceList.contains(hmilyXaResource)) {
            this.enlistResourceList.add(hmilyXaResource);
        }
        return true;
    }

    public int getStatus() throws SystemException {
        if (this.context.getCoordinator() != null) {
            return this.context.getCoordinator().getState().getState();
        }
        return this.subCoordinator.getState().getState();
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        if (synchronization == null) {
            return;
        }
        if (this.subCoordinator == null) {
            this.subCoordinator(false, true);
        }
        this.subCoordinator.addSynchronization(synchronization);
    }

    public void rollback() throws IllegalStateException, SystemException {
        Finally oneFinally = this.context.getOneFinally();
        if (oneFinally != null) {
            if (!this.hasSuper || this.getStatus() == XaState.STATUS_MARKED_ROLLBACK.getState().intValue()) {
                try {
                    oneFinally.rollback();
                }
                catch (RemoteException e) {
                    this.logger.error("rollback error {}", (Object)e.getMessage(), (Object)e);
                    throw new SystemException();
                }
            } else {
                this.doDeList(0x4000000);
            }
            return;
        }
        if (this.subCoordinator != null) {
            try {
                this.subCoordinator.rollback();
            }
            catch (RemoteException e) {
                this.logger.error("rollback error {}", (Object)e.getMessage(), (Object)e);
                throw new SystemException();
            }
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Coordinator coordinator = this.context.getCoordinator();
        if (coordinator != null) {
            coordinator.setRollbackOnly();
        }
        if (this.subCoordinator == null) {
            this.subCoordinator(false, false);
        }
        this.subCoordinator.setRollbackOnly();
    }

    private void subCoordinator(boolean newCoordinator, boolean stateActive) {
        try {
            this.subCoordinator = new SubCoordinator(this, this.hasSuper);
            if (!stateActive) {
                return;
            }
            Coordinator coordinator = this.context.getCoordinator();
            if (newCoordinator && coordinator == null) {
                coordinator = new Coordinator(this.xid, this.hasSuper);
                this.context.setCoordinator(coordinator);
                if (this.context.getOneFinally() == null) {
                    this.context.setOneFinally(coordinator);
                }
                coordinator.getTimer().put(coordinator, 30000L, TimeUnit.SECONDS);
                coordinator.getTimer().addRemovalListener(this);
            }
            coordinator.addCoordinators(this.subCoordinator);
        }
        catch (Exception ex) {
            this.logger.error("build SubCoordinator error");
        }
    }

    public XidImpl getXid() {
        return this.xid;
    }

    public TransactionContext getContext() {
        return this.context;
    }

    public TransactionImpl createSubTransaction() {
        return new TransactionImpl(this);
    }

    @Override
    public void onRemoval(Resource value, Long expire, Long elapsed) {
    }
}

