/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.xa.core;

import java.util.HashSet;
import java.util.Set;
import javax.sql.XAConnection;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.dromara.hmily.xa.core.HmilyXaTransactionManager;

public enum TransactionManagerImpl implements TransactionManager
{
    INST;

    private final ThreadLocal<Set<XAConnection>> enlisted = ThreadLocal.withInitial(HashSet::new);
    private HmilyXaTransactionManager hmilyXaTransactionManager;

    private TransactionManagerImpl() {
        this.initialized();
    }

    public void initialized() {
        this.hmilyXaTransactionManager = HmilyXaTransactionManager.initialized();
    }

    public void begin() throws NotSupportedException, SystemException {
        this.hmilyXaTransactionManager.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.hmilyXaTransactionManager.commit();
    }

    public int getStatus() throws SystemException {
        return this.hmilyXaTransactionManager.getState();
    }

    public Transaction getTransaction() {
        return this.hmilyXaTransactionManager.getTransaction();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.hmilyXaTransactionManager.resume(transaction);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.hmilyXaTransactionManager.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.hmilyXaTransactionManager.setRollbackOnly();
    }

    public void setTransactionTimeout(int i) throws SystemException {
        this.hmilyXaTransactionManager.setTransactionTimeout(i);
    }

    public Transaction suspend() throws SystemException {
        return this.hmilyXaTransactionManager.suspend();
    }

    public boolean isExistDataSources(final XAConnection connection) {
        boolean contains = this.enlisted.get().contains(connection);
        Transaction transaction = this.getTransaction();
        if (!contains) {
            try {
                transaction.registerSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                        ((Set)TransactionManagerImpl.this.enlisted.get()).remove(connection);
                    }

                    public void afterCompletion(int status) {
                        ((Set)TransactionManagerImpl.this.enlisted.get()).clear();
                        TransactionManagerImpl.this.enlisted.remove();
                    }
                });
            }
            catch (RollbackException | SystemException e) {
                return false;
            }
            this.enlisted.get().add(connection);
        }
        return contains;
    }

    public void markTransactionRollback(String transId) {
        this.hmilyXaTransactionManager.markTransactionRollback(transId);
    }
}

