/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.xa.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.transaction.xa.Xid;
import org.dromara.hmily.xa.core.XaResourceWrapped;

public final class XaResourcePool {
    public static final XaResourcePool INST = new XaResourcePool();
    private final Map<Xid, XaResourceWrapped> pool = new ConcurrentHashMap<Xid, XaResourceWrapped>();
    private final Map<String, Set<Xid>> xids = new ConcurrentHashMap<String, Set<Xid>>();

    private XaResourcePool() {
    }

    public synchronized void addResource(Xid xid, XaResourceWrapped xaResourceWrapped) {
        this.pool.put(xid, xaResourceWrapped);
        String globalId = new String(xid.getGlobalTransactionId());
        Set<Xid> xids = this.xids.get(globalId);
        if (xids == null) {
            xids = new HashSet<Xid>();
        }
        xids.add(xid);
        this.xids.put(globalId, xids);
    }

    public XaResourceWrapped removeResource(Xid xid) {
        String gid = new String(xid.getGlobalTransactionId());
        if (this.xids.containsKey(gid)) {
            this.xids.get(gid).remove(xid);
        }
        return this.pool.remove(xid);
    }

    public void removeAll(String globalId) {
        Set<Xid> xids = this.xids.get(globalId);
        if (xids != null) {
            for (Xid xid : xids) {
                this.removeResource(xid);
            }
            this.xids.remove(globalId);
        }
    }

    public XaResourceWrapped getResource(Xid xid) {
        XaResourceWrapped xaResourceWrapped = this.pool.get(xid);
        return xaResourceWrapped;
    }

    public List<XaResourceWrapped> getAllResource(String globalId) {
        Set<Xid> xids = this.xids.get(globalId);
        if (xids != null) {
            return xids.stream().map(this::getResource).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

