/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.xa.core;

import com.google.common.base.Splitter;
import java.util.List;
import javax.transaction.xa.Xid;
import org.dromara.hmily.common.utils.IdWorkerUtils;
import org.dromara.hmily.common.utils.NetUtils;

public class XidImpl
implements Xid {
    private static final Integer DEF_ID = 88088;
    private final String globalId;
    private final String branchId;
    private final byte[] globalIdByte;
    private final byte[] branchIdByte;

    public XidImpl() {
        long id = IdWorkerUtils.getInstance().createUUID();
        long bid = IdWorkerUtils.getInstance().createUUID();
        String newId = id + "-" + bid + "-" + NetUtils.getLocalIp();
        this.globalId = String.valueOf(id);
        this.branchId = newId;
        this.branchIdByte = newId.getBytes();
        this.globalIdByte = this.globalId.getBytes();
    }

    public XidImpl(XidImpl xId) {
        String newId;
        List xxIdx = Splitter.on((String)"-").splitToList((CharSequence)xId.getGlobalId());
        String gid = (String)xxIdx.get(0);
        long bid = IdWorkerUtils.getInstance().createUUID();
        this.branchId = newId = gid + "-" + bid + "-" + NetUtils.getLocalIp();
        this.branchIdByte = newId.getBytes();
        this.globalId = xId.getGlobalId();
        this.globalIdByte = xId.globalIdByte;
    }

    public XidImpl(String branchId) {
        String gid;
        List strings = Splitter.on((String)"-").splitToList((CharSequence)branchId);
        this.branchId = branchId;
        this.branchIdByte = branchId.getBytes();
        this.globalId = gid = (String)strings.get(0);
        this.globalIdByte = gid.getBytes();
    }

    public XidImpl(String transactionId, String branchId) {
        this.branchId = branchId;
        this.branchIdByte = branchId.getBytes();
        this.globalId = transactionId;
        this.globalIdByte = transactionId.getBytes();
    }

    public XidImpl(XidImpl xId, Integer index) {
        String newId;
        List xxIdx = Splitter.on((String)"-").splitToList((CharSequence)xId.getGlobalId());
        String gid = (String)xxIdx.get(0);
        long bid = IdWorkerUtils.getInstance().createUUID();
        this.branchId = newId = gid + "-" + bid + "-" + NetUtils.getLocalIp() + "-" + index;
        this.branchIdByte = newId.getBytes();
        this.globalId = xId.getGlobalId();
        this.globalIdByte = xId.globalIdByte;
    }

    public XidImpl(Xid xid) {
        this.globalIdByte = xid.getGlobalTransactionId();
        this.branchIdByte = xid.getBranchQualifier();
        this.globalId = new String(xid.getGlobalTransactionId());
        this.branchId = new String(xid.getBranchQualifier());
    }

    public String getGlobalId() {
        return this.globalId;
    }

    public String getBranchId() {
        return this.branchId;
    }

    @Override
    public int getFormatId() {
        return DEF_ID;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalIdByte;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchIdByte;
    }

    public XidImpl newBranchId() {
        return new XidImpl(this);
    }

    public XidImpl newResId(int index) {
        return new XidImpl(this, index);
    }

    public int hashCode() {
        int result = this.globalId != null ? this.globalId.hashCode() : 0;
        result = 31 * result + (this.branchId != null ? this.branchId.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof XidImpl) {
            return ((XidImpl)obj).getGlobalId().equals(this.getGlobalId()) && ((XidImpl)obj).getBranchId().equals(this.getBranchId());
        }
        return false;
    }

    public String toString() {
        return "XIdImpl{globalId='" + this.globalId + '\'' + ", branchId='" + this.branchId + '\'' + '}';
    }
}

