/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.xa.core.exception;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAException;

public class HmilyXaException
extends XAException {
    public static final int UNKNOWN = 1000;
    private static final Map<Integer, String> ERROR_CODES = new HashMap<Integer, String>();

    public HmilyXaException(int errorCode) {
        super(errorCode);
    }

    public static String getMessage(XAException xaException) {
        int errorCode = xaException.errorCode;
        String s = ERROR_CODES.get(errorCode);
        return "errorCode:" + errorCode + ":" + s;
    }

    static {
        ERROR_CODES.put(100, "the XaResource indicates that the rollback was caused by an unspecified reason.");
        ERROR_CODES.put(101, "the XaResource indicates that the rollback was caused by a communication failure.");
        ERROR_CODES.put(102, "the XaResource a deadlock was detected.");
        ERROR_CODES.put(103, "the XaResource a condition that violates the integrity of the resource was detected.");
        ERROR_CODES.put(104, "the XaResource the resource manager rolled back the transaction branch for a reason not on this list.");
        ERROR_CODES.put(105, "the XaResource a protocol error occurred in the resource manager.");
        ERROR_CODES.put(106, "the XaResource a transaction branch took too long.");
        ERROR_CODES.put(107, "the XaResource may retry the transaction branch.");
        ERROR_CODES.put(9, "the XaResource resumption must occur where the suspension occurred.");
        ERROR_CODES.put(8, "the XaResource the transaction branch may have been heuristically completed");
        ERROR_CODES.put(7, "the XaResource the transaction branch has been heuristically committed.");
        ERROR_CODES.put(6, "the XaResource the transaction branch has been heuristically rolled back.");
        ERROR_CODES.put(5, "the XaResource the transaction branch has been heuristically committed and rolled back.");
        ERROR_CODES.put(4, "the XaResource routine returned with no effect and may be reissued.");
        ERROR_CODES.put(3, "the XaResource the transaction branch was read-only and has been committed.");
        ERROR_CODES.put(-2, "the XaResource there is an asynchronous operation already outstanding.");
        ERROR_CODES.put(-3, "the XaResource a resource manager error has occurred in the transaction branch.");
        ERROR_CODES.put(-4, "the XaResource the XID is not valid.");
        ERROR_CODES.put(-5, "the XaResource invalid arguments were given.");
        ERROR_CODES.put(-6, "the XaResource routine was invoked in an inproper context.");
        ERROR_CODES.put(-7, "the XaResource resource manager is unavailable.");
        ERROR_CODES.put(-8, "the XaResource the XID already exists.");
        ERROR_CODES.put(-9, "the XaResource the resource manager is doing work outside a global transaction.");
    }
}

