/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.xa.core.recovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.dromara.hmily.core.repository.HmilyRepositoryFacade;
import org.dromara.hmily.repository.spi.HmilyRepository;
import org.dromara.hmily.repository.spi.HmilyXaRepository;
import org.dromara.hmily.repository.spi.entity.HmilyXaRecovery;
import org.dromara.hmily.xa.core.XidImpl;
import org.dromara.hmily.xa.core.recovery.RecoveryLog;
import org.dromara.hmily.xa.core.recovery.XaResourceRecovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XaResourceRecoveryImpl
implements XaResourceRecovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(XaResourceRecoveryImpl.class);
    private volatile HmilyXaRepository repository;

    @Override
    public void commitLog(RecoveryLog recoveryLog) {
        HmilyXaRecovery recovery = recoveryLog.getRecovery();
        this.repository().addLog(recovery);
    }

    @Override
    public void rollbackLog(RecoveryLog recoveryLog) {
        HmilyXaRecovery recovery = recoveryLog.getRecovery();
        String tmUnique = recovery.getTmUnique();
        Integer state = recovery.getState();
        List hmilyXaRecoveries = this.repository.queryByTmUnique(tmUnique, state);
    }

    @Override
    public void recover(String tmUnique, XAResource resource) {
        if (resource == null) {
            return;
        }
        List hmilyXaRecoveries = this.repository.queryByTmUnique(tmUnique, Integer.valueOf(0));
    }

    private List<XidImpl> recoverXids(XAResource xaResource) {
        int flags = 0x1000000;
        ArrayList<XidImpl> xIds = new ArrayList<XidImpl>();
        try {
            boolean done;
            do {
                Xid[] recover = xaResource.recover(flags);
                flags = 0;
                boolean bl = done = recover == null || recover.length <= 0;
                if (done) continue;
                done = true;
                for (Xid xid : recover) {
                    XidImpl xidImpl = new XidImpl(xid);
                    if (xIds.contains(xidImpl)) continue;
                    xIds.add(xidImpl);
                    done = false;
                }
            } while (!done);
        }
        catch (XAException xaException) {
            LOGGER.warn("recover xids error", (Throwable)xaException);
            return Collections.emptyList();
        }
        return xIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HmilyXaRepository repository() {
        if (this.repository == null) {
            XaResourceRecoveryImpl xaResourceRecoveryImpl = this;
            synchronized (xaResourceRecoveryImpl) {
                if (this.repository == null) {
                    try {
                        HmilyRepository hmilyRepository1 = HmilyRepositoryFacade.getInstance().getHmilyRepository();
                        if (hmilyRepository1 instanceof HmilyXaRepository) {
                            this.repository = (HmilyXaRepository)hmilyRepository1;
                        }
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Repository \u6ca1\u6709\u5b9e\u73b0HmilyXaRepository\u63a5\u53e3.");
                    }
                }
            }
        }
        return this.repository;
    }
}

