/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.xa.core.timer;

import java.util.concurrent.TimeUnit;
import org.dromara.hmily.common.concurrent.HmilyThreadFactory;
import org.dromara.hmily.xa.core.timer.HashedWheelTimer;
import org.dromara.hmily.xa.core.timer.Timeout;
import org.dromara.hmily.xa.core.timer.TimerRemovalListener;
import org.dromara.hmily.xa.core.timer.TimerTask;

public class HmilyTimer<V> {
    private final long expire;
    private final HashedWheelTimer timer;
    private TimerRemovalListener<V> timerRemovalListener;
    private final TimeUnit unit;

    public HmilyTimer(long expire, TimeUnit unit, String cacheName) {
        this.expire = expire;
        this.timer = new HashedWheelTimer(HmilyThreadFactory.create((String)cacheName, (boolean)false));
        this.unit = unit;
    }

    public void addRemovalListener(TimerRemovalListener<V> listener) {
        this.timerRemovalListener = listener;
    }

    public Timeout put(V v) {
        return this.put(v, this.expire, this.unit);
    }

    public Timeout put(V v, long expire, TimeUnit unit) {
        Node node = new Node(v, expire, unit);
        return this.timer.newTimeout(node, expire, unit);
    }

    public class Node
    implements TimerTask {
        private final V value;
        private final Long time;
        private final Long expire;
        private final TimeUnit unit;

        public Node(V value, long expire, TimeUnit unit) {
            this.value = value;
            this.time = System.nanoTime();
            this.expire = expire;
            this.unit = unit;
        }

        public V getValue() {
            return this.value;
        }

        public Long getTime() {
            return this.time;
        }

        @Override
        public void run(Timeout timeout) {
            if (HmilyTimer.this.timerRemovalListener != null) {
                long elapsed = System.nanoTime() - this.time;
                long sd = this.unit.toMillis(this.expire);
                long ss = TimeUnit.NANOSECONDS.toMillis(elapsed);
                HmilyTimer.this.timerRemovalListener.onRemoval(this.value, sd, ss);
            }
        }
    }
}

