/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.xa.p6spy;

import com.p6spy.engine.spy.P6DataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.dromara.hmily.common.exception.HmilyException;
import org.dromara.hmily.xa.p6spy.HmilyXaConnection;

public class HmilyXaP6Datasource
extends P6DataSource {
    private DataSource targetDataSource;

    public HmilyXaP6Datasource(DataSource delegate) {
        super(delegate);
        this.init(delegate);
    }

    public Connection getConnection() throws SQLException {
        XAConnection xaConnection = super.getXAConnection();
        return this.getHmilyConnection(xaConnection);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        XAConnection connection = super.getXAConnection(username, password);
        return this.getHmilyConnection(connection);
    }

    private Connection getHmilyConnection(XAConnection xaConnection) throws SQLException {
        return new HmilyXaConnection(xaConnection);
    }

    private void init(DataSource delegate) {
        if (delegate == null) {
            throw new NullPointerException("targetDataSource is null");
        }
        if (!(delegate instanceof XADataSource)) {
            throw new HmilyException("datasource non implements XADataSource");
        }
        this.targetDataSource = delegate;
    }

    public DataSource getTargetDataSource() {
        return this.targetDataSource;
    }
}

