/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.thread;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final boolean isDaemon;
    private final Thread.UncaughtExceptionHandler handler;

    public NamedThreadFactory(String prefix, boolean isDaemon) {
        this(prefix, null, isDaemon);
    }

    public NamedThreadFactory(String prefix, ThreadGroup threadGroup, boolean isDaemon) {
        this(prefix, threadGroup, isDaemon, null);
    }

    public NamedThreadFactory(String prefix, ThreadGroup threadGroup, boolean isDaemon, Thread.UncaughtExceptionHandler handler) {
        String string = this.prefix = StrUtil.isBlank(prefix) ? "Hutool" : prefix;
        if (null == threadGroup) {
            threadGroup = ThreadUtil.currentThreadGroup();
        }
        this.group = threadGroup;
        this.isDaemon = isDaemon;
        this.handler = handler;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t2 = new Thread(this.group, r, StrUtil.format("{}{}", this.prefix, this.threadNumber.getAndIncrement()));
        if (!t2.isDaemon()) {
            if (this.isDaemon) {
                t2.setDaemon(true);
            }
        } else if (!this.isDaemon) {
            t2.setDaemon(false);
        }
        if (null != this.handler) {
            t2.setUncaughtExceptionHandler(this.handler);
        }
        if (5 != t2.getPriority()) {
            t2.setPriority(5);
        }
        return t2;
    }
}

