/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log.dialect.jdk;

import cn.hutool.core.util.StrUtil;
import cn.hutool.log.AbstractLog;
import cn.hutool.log.level.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JdkLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final transient Logger logger;

    public JdkLog(Logger logger) {
        this.logger = logger;
    }

    public JdkLog(Class<?> clazz) {
        this(null == clazz ? "null" : clazz.getName());
    }

    public JdkLog(String name) {
        this(Logger.getLogger(name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.FINEST);
    }

    @Override
    public void trace(String fqcn, Throwable t2, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, java.util.logging.Level.FINEST, t2, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.FINE);
    }

    @Override
    public void debug(String fqcn, Throwable t2, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, java.util.logging.Level.FINE, t2, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.INFO);
    }

    @Override
    public void info(String fqcn, Throwable t2, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, java.util.logging.Level.INFO, t2, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.WARNING);
    }

    @Override
    public void warn(String fqcn, Throwable t2, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, java.util.logging.Level.WARNING, t2, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.SEVERE);
    }

    @Override
    public void error(String fqcn, Throwable t2, String format, Object ... arguments) {
        this.logIfEnabled(fqcn, java.util.logging.Level.SEVERE, t2, format, arguments);
    }

    @Override
    public void log(String fqcn, Level level, Throwable t2, String format, Object ... arguments) {
        java.util.logging.Level jdkLevel;
        switch (level) {
            case TRACE: {
                jdkLevel = java.util.logging.Level.FINEST;
                break;
            }
            case DEBUG: {
                jdkLevel = java.util.logging.Level.FINE;
                break;
            }
            case INFO: {
                jdkLevel = java.util.logging.Level.INFO;
                break;
            }
            case WARN: {
                jdkLevel = java.util.logging.Level.WARNING;
                break;
            }
            case ERROR: {
                jdkLevel = java.util.logging.Level.SEVERE;
                break;
            }
            default: {
                throw new Error(StrUtil.format("Can not identify level: {}", new Object[]{level}));
            }
        }
        this.logIfEnabled(fqcn, jdkLevel, t2, format, arguments);
    }

    private void logIfEnabled(String callerFQCN, java.util.logging.Level level, Throwable throwable, String format, Object[] arguments) {
        if (this.logger.isLoggable(level)) {
            LogRecord record = new LogRecord(level, StrUtil.format(format, arguments));
            record.setLoggerName(this.getName());
            record.setThrown(throwable);
            JdkLog.fillCallerData(callerFQCN, record);
            this.logger.log(record);
        }
    }

    private static void fillCallerData(String callerFQCN, LogRecord record) {
        StackTraceElement[] steArray = Thread.currentThread().getStackTrace();
        int found = -1;
        for (int i = steArray.length - 2; i > -1; --i) {
            String className = steArray[i].getClassName();
            if (!callerFQCN.equals(className)) continue;
            found = i;
            break;
        }
        if (found > -1) {
            StackTraceElement ste = steArray[found + 1];
            record.setSourceClassName(ste.getClassName());
            record.setSourceMethodName(ste.getMethodName());
        }
    }
}

