/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log.dialect.log4j;

import cn.hutool.core.util.StrUtil;
import cn.hutool.log.AbstractLog;
import cn.hutool.log.level.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final Logger logger;

    public Log4jLog(Logger logger) {
        this.logger = logger;
    }

    public Log4jLog(Class<?> clazz) {
        this(null == clazz ? "null" : clazz.getName());
    }

    public Log4jLog(String name) {
        this(Logger.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String fqcn, Throwable t2, String format, Object ... arguments) {
        this.log(fqcn, Level.TRACE, t2, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String fqcn, Throwable t2, String format, Object ... arguments) {
        this.log(fqcn, Level.DEBUG, t2, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String fqcn, Throwable t2, String format, Object ... arguments) {
        this.log(fqcn, Level.INFO, t2, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.WARN);
    }

    @Override
    public void warn(String fqcn, Throwable t2, String format, Object ... arguments) {
        this.log(fqcn, Level.WARN, t2, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.ERROR);
    }

    @Override
    public void error(String fqcn, Throwable t2, String format, Object ... arguments) {
        this.log(fqcn, Level.ERROR, t2, format, arguments);
    }

    @Override
    public void log(String fqcn, Level level, Throwable t2, String format, Object ... arguments) {
        org.apache.log4j.Level log4jLevel;
        switch (level) {
            case TRACE: {
                log4jLevel = org.apache.log4j.Level.TRACE;
                break;
            }
            case DEBUG: {
                log4jLevel = org.apache.log4j.Level.DEBUG;
                break;
            }
            case INFO: {
                log4jLevel = org.apache.log4j.Level.INFO;
                break;
            }
            case WARN: {
                log4jLevel = org.apache.log4j.Level.WARN;
                break;
            }
            case ERROR: {
                log4jLevel = org.apache.log4j.Level.ERROR;
                break;
            }
            default: {
                throw new Error(StrUtil.format("Can not identify level: {}", new Object[]{level}));
            }
        }
        if (this.logger.isEnabledFor((Priority)log4jLevel)) {
            this.logger.log(fqcn, (Priority)log4jLevel, (Object)StrUtil.format(format, arguments), t2);
        }
    }
}

