/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.ByteString;
import io.protostuff.GraphInput;
import io.protostuff.Input;
import io.protostuff.MapSchema;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.ProtostuffException;
import io.protostuff.Schema;
import io.protostuff.runtime.Delegate;
import io.protostuff.runtime.EnumIO;
import io.protostuff.runtime.HasSchema;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.PolymorphicSchema;
import io.protostuff.runtime.RuntimeFieldFactory;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;

public final class ArraySchemas {
    static final int ID_ARRAY_LEN = 1;
    static final int ID_ARRAY_DATA = 2;
    static final int ID_ARRAY_NULLCOUNT = 3;
    static final String STR_ARRAY_LEN = "a";
    static final String STR_ARRAY_DATA = "b";
    static final String STR_ARRAY_NULLCOUNT = "c";
    static final PolymorphicSchema.Handler GENERIC_HANDLER = new PolymorphicSchema.Handler(){

        @Override
        public void setValue(Object value, Object owner) {
            if (MapSchema.MapWrapper.class == owner.getClass()) {
                ((MapSchema.MapWrapper)owner).setValue(value);
            } else {
                ((Collection)owner).add(value);
            }
        }
    };

    private ArraySchemas() {
    }

    static boolean isPrimitive(int arrayId) {
        return arrayId < 8;
    }

    static int toArrayId(int id, boolean primitive) {
        if (primitive) {
            return id - 1;
        }
        return id < 9 ? id - 1 | 8 : id + 7;
    }

    static int toInlineId(int arrayId) {
        if (arrayId < 8) {
            return arrayId + 1;
        }
        if (arrayId < 16) {
            return 1 + (arrayId & 7);
        }
        return arrayId - 7;
    }

    static Base getSchema(int id, boolean primitive, IdStrategy strategy) {
        switch (id) {
            case 1: {
                return primitive ? strategy.ARRAY_BOOL_PRIMITIVE_SCHEMA : strategy.ARRAY_BOOL_BOXED_SCHEMA;
            }
            case 3: {
                return primitive ? strategy.ARRAY_CHAR_PRIMITIVE_SCHEMA : strategy.ARRAY_CHAR_BOXED_SCHEMA;
            }
            case 4: {
                return primitive ? strategy.ARRAY_SHORT_PRIMITIVE_SCHEMA : strategy.ARRAY_SHORT_BOXED_SCHEMA;
            }
            case 5: {
                return primitive ? strategy.ARRAY_INT32_PRIMITIVE_SCHEMA : strategy.ARRAY_INT32_BOXED_SCHEMA;
            }
            case 6: {
                return primitive ? strategy.ARRAY_INT64_PRIMITIVE_SCHEMA : strategy.ARRAY_INT64_BOXED_SCHEMA;
            }
            case 7: {
                return primitive ? strategy.ARRAY_FLOAT_PRIMITIVE_SCHEMA : strategy.ARRAY_FLOAT_BOXED_SCHEMA;
            }
            case 8: {
                return primitive ? strategy.ARRAY_DOUBLE_PRIMITIVE_SCHEMA : strategy.ARRAY_DOUBLE_BOXED_SCHEMA;
            }
            case 9: {
                return strategy.ARRAY_STRING_SCHEMA;
            }
            case 10: {
                return strategy.ARRAY_BYTESTRING_SCHEMA;
            }
            case 11: {
                return strategy.ARRAY_BYTEARRAY_SCHEMA;
            }
            case 12: {
                return strategy.ARRAY_BIGDECIMAL_SCHEMA;
            }
            case 13: {
                return strategy.ARRAY_BIGINTEGER_SCHEMA;
            }
            case 14: {
                return strategy.ARRAY_DATE_SCHEMA;
            }
        }
        throw new RuntimeException("Should not happen.");
    }

    static Base getGenericElementSchema(int id, IdStrategy strategy) {
        switch (id) {
            case 1: {
                return strategy.ARRAY_BOOL_DERIVED_SCHEMA;
            }
            case 3: {
                return strategy.ARRAY_CHAR_DERIVED_SCHEMA;
            }
            case 4: {
                return strategy.ARRAY_SHORT_DERIVED_SCHEMA;
            }
            case 5: {
                return strategy.ARRAY_INT32_DERIVED_SCHEMA;
            }
            case 6: {
                return strategy.ARRAY_INT64_DERIVED_SCHEMA;
            }
            case 7: {
                return strategy.ARRAY_FLOAT_DERIVED_SCHEMA;
            }
            case 8: {
                return strategy.ARRAY_DOUBLE_DERIVED_SCHEMA;
            }
            case 9: {
                return strategy.ARRAY_STRING_SCHEMA;
            }
            case 10: {
                return strategy.ARRAY_BYTESTRING_SCHEMA;
            }
            case 11: {
                return strategy.ARRAY_BYTEARRAY_SCHEMA;
            }
            case 12: {
                return strategy.ARRAY_BIGDECIMAL_SCHEMA;
            }
            case 13: {
                return strategy.ARRAY_BIGINTEGER_SCHEMA;
            }
            case 14: {
                return strategy.ARRAY_DATE_SCHEMA;
            }
        }
        throw new RuntimeException("Should not happen.");
    }

    static Base newSchema(int id, Class<?> compontentType, Class<?> typeClass, IdStrategy strategy, PolymorphicSchema.Handler handler) {
        switch (id) {
            case 1: {
                return new BoolArray(strategy, handler, compontentType.isPrimitive());
            }
            case 3: {
                return new CharArray(strategy, handler, compontentType.isPrimitive());
            }
            case 4: {
                return new ShortArray(strategy, handler, compontentType.isPrimitive());
            }
            case 5: {
                return new Int32Array(strategy, handler, compontentType.isPrimitive());
            }
            case 6: {
                return new Int64Array(strategy, handler, compontentType.isPrimitive());
            }
            case 7: {
                return new FloatArray(strategy, handler, compontentType.isPrimitive());
            }
            case 8: {
                return new DoubleArray(strategy, handler, compontentType.isPrimitive());
            }
            case 9: {
                return new StringArray(strategy, handler);
            }
            case 10: {
                return new ByteStringArray(strategy, handler);
            }
            case 11: {
                return new ByteArrayArray(strategy, handler);
            }
            case 12: {
                return new BigDecimalArray(strategy, handler);
            }
            case 13: {
                return new BigIntegerArray(strategy, handler);
            }
            case 14: {
                return new DateArray(strategy, handler);
            }
        }
        throw new RuntimeException("Should not happen.");
    }

    static String name(int number) {
        switch (number) {
            case 1: {
                return STR_ARRAY_LEN;
            }
            case 2: {
                return STR_ARRAY_DATA;
            }
            case 3: {
                return STR_ARRAY_NULLCOUNT;
            }
        }
        return null;
    }

    static int number(String name) {
        if (name.length() != 1) {
            return 0;
        }
        switch (name.charAt(0)) {
            case 'a': {
                return 1;
            }
            case 'b': {
                return 2;
            }
            case 'c': {
                return 3;
            }
        }
        return 0;
    }

    static void transferObject(Pipe.Schema<Object> pipeSchema, Pipe pipe, Input input, Output output, IdStrategy strategy, Delegate<?> delegate) throws IOException {
        if (1 != input.readFieldNumber(pipeSchema.wrappedSchema)) {
            throw new ProtostuffException("Corrupt input.");
        }
        int len = input.readInt32();
        output.writeInt32(1, len, false);
        if (len < 0) {
            len = -len - 1;
        }
        int i = 0;
        int nullCount = 0;
        block4: while (i < len) {
            switch (input.readFieldNumber(pipeSchema.wrappedSchema)) {
                case 2: {
                    ++i;
                    delegate.transfer(pipe, input, output, 2, true);
                    continue block4;
                }
                case 3: {
                    nullCount = input.readUInt32();
                    i += nullCount;
                    output.writeUInt32(3, nullCount, false);
                    continue block4;
                }
            }
            throw new ProtostuffException("Corrupt input.");
        }
        if (0 != input.readFieldNumber(pipeSchema.wrappedSchema)) {
            throw new ProtostuffException("Corrupt input.");
        }
    }

    public static class PojoArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                if (1 != input.readFieldNumber(PojoArray.this.pipeSchema.wrappedSchema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                int len = input.readInt32();
                output.writeInt32(1, len, false);
                int i = 0;
                int nullCount = 0;
                block4: while (i < len) {
                    switch (input.readFieldNumber(PojoArray.this.pipeSchema.wrappedSchema)) {
                        case 2: {
                            ++i;
                            output.writeObject(2, pipe, PojoArray.this.hs.getPipeSchema(), true);
                            continue block4;
                        }
                        case 3: {
                            nullCount = input.readUInt32();
                            i += nullCount;
                            output.writeUInt32(3, nullCount, false);
                            continue block4;
                        }
                    }
                    throw new ProtostuffException("Corrupt input.");
                }
                if (0 != input.readFieldNumber(PojoArray.this.pipeSchema.wrappedSchema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
            }
        };
        final HasSchema<Object> hs;

        public PojoArray(IdStrategy strategy, PolymorphicSchema.Handler handler, HasSchema<Object> hs) {
            super(strategy, handler);
            this.hs = hs;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            Object[] array = (Object[])Array.newInstance(this.hs.getSchema().typeClass(), len);
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = input.mergeObject(null, this.hs.getSchema());
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public void writeTo(Output output, Object message) throws IOException {
            Object[] array = (Object[])message;
            int len = array.length;
            output.writeInt32(1, len, false);
            int nullCount = 0;
            for (int i = 0; i < len; ++i) {
                Object v = array[i];
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeObject(2, v, this.hs.getSchema(), true);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class EnumArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                if (1 != input.readFieldNumber(EnumArray.this.pipeSchema.wrappedSchema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                int len = input.readInt32();
                output.writeInt32(1, len, false);
                int i = 0;
                int nullCount = 0;
                block4: while (i < len) {
                    switch (input.readFieldNumber(EnumArray.this.pipeSchema.wrappedSchema)) {
                        case 2: {
                            ++i;
                            EnumIO.transfer(pipe, input, output, 2, true, EnumArray.this.eio.strategy);
                            continue block4;
                        }
                        case 3: {
                            nullCount = input.readUInt32();
                            i += nullCount;
                            output.writeUInt32(3, nullCount, false);
                            continue block4;
                        }
                    }
                    throw new ProtostuffException("Corrupt input.");
                }
                if (0 != input.readFieldNumber(EnumArray.this.pipeSchema.wrappedSchema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
            }
        };
        final EnumIO<?> eio;

        public EnumArray(IdStrategy strategy, PolymorphicSchema.Handler handler, EnumIO<?> eio) {
            super(strategy, handler);
            this.eio = eio;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            Object[] array = (Object[])Array.newInstance(this.eio.enumClass, len);
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = this.eio.readFrom(input);
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public void writeTo(Output output, Object message) throws IOException {
            Enum[] array = (Enum[])message;
            int len = array.length;
            output.writeInt32(1, len, false);
            int nullCount = 0;
            for (int i = 0; i < len; ++i) {
                Enum v = array[i];
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    this.eio.writeTo(output, 2, true, v);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class DelegateArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, DelegateArray.this.strategy, DelegateArray.this.delegate);
            }
        };
        final Delegate<Object> delegate;

        public DelegateArray(IdStrategy strategy, PolymorphicSchema.Handler handler, Delegate<Object> delegate) {
            super(strategy, handler);
            this.delegate = delegate;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            Object[] array = (Object[])Array.newInstance(this.delegate.typeClass(), len);
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = this.delegate.readFrom(input);
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public void writeTo(Output output, Object message) throws IOException {
            Object[] array = (Object[])message;
            int len = array.length;
            output.writeInt32(1, len, false);
            int nullCount = 0;
            for (int i = 0; i < len; ++i) {
                Object v = array[i];
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    this.delegate.writeTo(output, 2, v, true);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class DateArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, DateArray.this.strategy, RuntimeFieldFactory.DATE);
            }
        };

        DateArray(IdStrategy strategy, PolymorphicSchema.Handler handler) {
            super(strategy, handler);
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            Date[] array = new Date[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = new Date(input.readFixed64());
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public void writeTo(Output output, Object value) throws IOException {
            Date[] array = (Date[])value;
            output.writeInt32(1, array.length, false);
            int nullCount = 0;
            for (Date v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeFixed64(2, v.getTime(), true);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class BigIntegerArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, BigIntegerArray.this.strategy, RuntimeFieldFactory.BIGINTEGER);
            }
        };

        BigIntegerArray(IdStrategy strategy, PolymorphicSchema.Handler handler) {
            super(strategy, handler);
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            BigInteger[] array = new BigInteger[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = new BigInteger(input.readByteArray());
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public void writeTo(Output output, Object value) throws IOException {
            BigInteger[] array = (BigInteger[])value;
            output.writeInt32(1, array.length, false);
            int nullCount = 0;
            for (BigInteger v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeByteArray(2, v.toByteArray(), true);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class BigDecimalArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, BigDecimalArray.this.strategy, RuntimeFieldFactory.BIGDECIMAL);
            }
        };

        BigDecimalArray(IdStrategy strategy, PolymorphicSchema.Handler handler) {
            super(strategy, handler);
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            BigDecimal[] array = new BigDecimal[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = new BigDecimal(input.readString());
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public void writeTo(Output output, Object value) throws IOException {
            BigDecimal[] array = (BigDecimal[])value;
            output.writeInt32(1, array.length, false);
            int nullCount = 0;
            for (BigDecimal v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeString(2, v.toString(), true);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class ByteArrayArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, ByteArrayArray.this.strategy, RuntimeFieldFactory.BYTE_ARRAY);
            }
        };

        ByteArrayArray(IdStrategy strategy, PolymorphicSchema.Handler handler) {
            super(strategy, handler);
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            byte[][] array = new byte[len][];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = input.readByteArray();
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public void writeTo(Output output, Object value) throws IOException {
            byte[][] array = (byte[][])value;
            output.writeInt32(1, array.length, false);
            int nullCount = 0;
            for (byte[] v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeByteArray(2, v, true);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class ByteStringArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, ByteStringArray.this.strategy, RuntimeFieldFactory.BYTES);
            }
        };

        ByteStringArray(IdStrategy strategy, PolymorphicSchema.Handler handler) {
            super(strategy, handler);
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            ByteString[] array = new ByteString[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = input.readBytes();
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public void writeTo(Output output, Object value) throws IOException {
            ByteString[] array = (ByteString[])value;
            output.writeInt32(1, array.length, false);
            int nullCount = 0;
            for (ByteString v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeBytes(2, v, true);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class StringArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, StringArray.this.strategy, RuntimeFieldFactory.STRING);
            }
        };

        StringArray(IdStrategy strategy, PolymorphicSchema.Handler handler) {
            super(strategy, handler);
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            String[] array = new String[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = input.readString();
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public void writeTo(Output output, Object value) throws IOException {
            CharSequence[] array = (CharSequence[])value;
            output.writeInt32(1, array.length, false);
            int nullCount = 0;
            for (CharSequence v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeString(2, v, true);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }
    }

    public static class DoubleArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, DoubleArray.this.strategy, RuntimeFieldFactory.DOUBLE);
            }
        };
        final boolean primitive;

        DoubleArray(IdStrategy strategy, PolymorphicSchema.Handler handler, boolean primitive) {
            super(strategy, handler);
            this.primitive = primitive;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        protected Object readPrimitiveFrom(Input input, Object owner, int len) throws IOException {
            double[] array = new double[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            for (int i = 0; i < len; ++i) {
                if (2 != input.readFieldNumber(this)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                array[i] = input.readDouble();
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        protected Object readBoxedFrom(Input input, Object owner, int len) throws IOException {
            Double[] array = new Double[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = input.readDouble();
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            return this.primitive ? this.readPrimitiveFrom(input, owner, len) : this.readBoxedFrom(input, owner, len);
        }

        protected void writeLengthTo(Output output, int len, boolean primitive) throws IOException {
            output.writeInt32(1, len, false);
        }

        protected void writeTo(Output output, Object value, boolean primitive) throws IOException {
            if (primitive) {
                double[] array = (double[])value;
                this.writeLengthTo(output, array.length, true);
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    output.writeDouble(2, array[i], true);
                }
                return;
            }
            Double[] array = (Double[])value;
            this.writeLengthTo(output, array.length, false);
            int nullCount = 0;
            for (Double v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeDouble(2, v, true);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }

        @Override
        public void writeTo(Output output, Object value) throws IOException {
            this.writeTo(output, value, this.primitive);
        }
    }

    public static class FloatArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, FloatArray.this.strategy, RuntimeFieldFactory.FLOAT);
            }
        };
        final boolean primitive;

        FloatArray(IdStrategy strategy, PolymorphicSchema.Handler handler, boolean primitive) {
            super(strategy, handler);
            this.primitive = primitive;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        protected Object readPrimitiveFrom(Input input, Object owner, int len) throws IOException {
            float[] array = new float[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            for (int i = 0; i < len; ++i) {
                if (2 != input.readFieldNumber(this)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                array[i] = input.readFloat();
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        protected Object readBoxedFrom(Input input, Object owner, int len) throws IOException {
            Float[] array = new Float[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = Float.valueOf(input.readFloat());
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            return this.primitive ? this.readPrimitiveFrom(input, owner, len) : this.readBoxedFrom(input, owner, len);
        }

        protected void writeLengthTo(Output output, int len, boolean primitive) throws IOException {
            output.writeInt32(1, len, false);
        }

        protected void writeTo(Output output, Object value, boolean primitive) throws IOException {
            if (primitive) {
                float[] array = (float[])value;
                this.writeLengthTo(output, array.length, true);
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    output.writeFloat(2, array[i], true);
                }
                return;
            }
            Float[] array = (Float[])value;
            this.writeLengthTo(output, array.length, false);
            int nullCount = 0;
            for (Float v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeFloat(2, v.floatValue(), true);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }

        @Override
        public void writeTo(Output output, Object value) throws IOException {
            this.writeTo(output, value, this.primitive);
        }
    }

    public static class Int64Array
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, Int64Array.this.strategy, RuntimeFieldFactory.INT64);
            }
        };
        final boolean primitive;

        Int64Array(IdStrategy strategy, PolymorphicSchema.Handler handler, boolean primitive) {
            super(strategy, handler);
            this.primitive = primitive;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        protected Object readPrimitiveFrom(Input input, Object owner, int len) throws IOException {
            long[] array = new long[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            for (int i = 0; i < len; ++i) {
                if (2 != input.readFieldNumber(this)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                array[i] = input.readInt64();
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        protected Object readBoxedFrom(Input input, Object owner, int len) throws IOException {
            Long[] array = new Long[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = input.readInt64();
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            return this.primitive ? this.readPrimitiveFrom(input, owner, len) : this.readBoxedFrom(input, owner, len);
        }

        protected void writeLengthTo(Output output, int len, boolean primitive) throws IOException {
            output.writeInt32(1, len, false);
        }

        protected void writeTo(Output output, Object value, boolean primitive) throws IOException {
            if (primitive) {
                long[] array = (long[])value;
                this.writeLengthTo(output, array.length, true);
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    output.writeInt64(2, array[i], true);
                }
                return;
            }
            Long[] array = (Long[])value;
            this.writeLengthTo(output, array.length, false);
            int nullCount = 0;
            for (Long v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeInt64(2, v, true);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }

        @Override
        public void writeTo(Output output, Object value) throws IOException {
            this.writeTo(output, value, this.primitive);
        }
    }

    public static class Int32Array
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, Int32Array.this.strategy, RuntimeFieldFactory.INT32);
            }
        };
        final boolean primitive;

        Int32Array(IdStrategy strategy, PolymorphicSchema.Handler handler, boolean primitive) {
            super(strategy, handler);
            this.primitive = primitive;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        protected Object readPrimitiveFrom(Input input, Object owner, int len) throws IOException {
            int[] array = new int[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            for (int i = 0; i < len; ++i) {
                if (2 != input.readFieldNumber(this)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                array[i] = input.readInt32();
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        protected Object readBoxedFrom(Input input, Object owner, int len) throws IOException {
            Integer[] array = new Integer[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = input.readInt32();
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            return this.primitive ? this.readPrimitiveFrom(input, owner, len) : this.readBoxedFrom(input, owner, len);
        }

        protected void writeLengthTo(Output output, int len, boolean primitive) throws IOException {
            output.writeInt32(1, len, false);
        }

        protected void writeTo(Output output, Object value, boolean primitive) throws IOException {
            if (primitive) {
                int[] array = (int[])value;
                this.writeLengthTo(output, array.length, true);
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    output.writeInt32(2, array[i], true);
                }
                return;
            }
            Integer[] array = (Integer[])value;
            this.writeLengthTo(output, array.length, false);
            int nullCount = 0;
            for (Integer v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeInt32(2, v, true);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }

        @Override
        public void writeTo(Output output, Object value) throws IOException {
            this.writeTo(output, value, this.primitive);
        }
    }

    public static class ShortArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, ShortArray.this.strategy, RuntimeFieldFactory.SHORT);
            }
        };
        final boolean primitive;

        ShortArray(IdStrategy strategy, PolymorphicSchema.Handler handler, boolean primitive) {
            super(strategy, handler);
            this.primitive = primitive;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        protected Object readPrimitiveFrom(Input input, Object owner, int len) throws IOException {
            short[] array = new short[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            for (int i = 0; i < len; ++i) {
                if (2 != input.readFieldNumber(this)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                array[i] = (short)input.readUInt32();
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        protected Object readBoxedFrom(Input input, Object owner, int len) throws IOException {
            Short[] array = new Short[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = (short)input.readUInt32();
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            return this.primitive ? this.readPrimitiveFrom(input, owner, len) : this.readBoxedFrom(input, owner, len);
        }

        protected void writeLengthTo(Output output, int len, boolean primitive) throws IOException {
            output.writeInt32(1, len, false);
        }

        protected void writeTo(Output output, Object value, boolean primitive) throws IOException {
            if (primitive) {
                short[] array = (short[])value;
                this.writeLengthTo(output, array.length, true);
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    output.writeUInt32(2, array[i], true);
                }
                return;
            }
            Short[] array = (Short[])value;
            this.writeLengthTo(output, array.length, false);
            int nullCount = 0;
            for (Short v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeUInt32(2, v.shortValue(), true);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }

        @Override
        public void writeTo(Output output, Object value) throws IOException {
            this.writeTo(output, value, this.primitive);
        }
    }

    public static class CharArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, CharArray.this.strategy, RuntimeFieldFactory.CHAR);
            }
        };
        final boolean primitive;

        CharArray(IdStrategy strategy, PolymorphicSchema.Handler handler, boolean primitive) {
            super(strategy, handler);
            this.primitive = primitive;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        protected Object readPrimitiveFrom(Input input, Object owner, int len) throws IOException {
            char[] array = new char[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            for (int i = 0; i < len; ++i) {
                if (2 != input.readFieldNumber(this)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                array[i] = (char)input.readUInt32();
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        protected Object readBoxedFrom(Input input, Object owner, int len) throws IOException {
            Character[] array = new Character[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = Character.valueOf((char)input.readUInt32());
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            return this.primitive ? this.readPrimitiveFrom(input, owner, len) : this.readBoxedFrom(input, owner, len);
        }

        protected void writeLengthTo(Output output, int len, boolean primitive) throws IOException {
            output.writeInt32(1, len, false);
        }

        protected void writeTo(Output output, Object value, boolean primitive) throws IOException {
            if (primitive) {
                char[] array = (char[])value;
                this.writeLengthTo(output, array.length, true);
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    output.writeUInt32(2, array[i], true);
                }
                return;
            }
            Character[] array = (Character[])value;
            this.writeLengthTo(output, array.length, false);
            int nullCount = 0;
            for (Character v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeUInt32(2, v.charValue(), true);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }

        @Override
        public void writeTo(Output output, Object value) throws IOException {
            this.writeTo(output, value, this.primitive);
        }
    }

    public static class BoolArray
    extends Base {
        protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

            @Override
            protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
                ArraySchemas.transferObject(this, pipe, input, output, BoolArray.this.strategy, RuntimeFieldFactory.BOOL);
            }
        };
        final boolean primitive;

        BoolArray(IdStrategy strategy, PolymorphicSchema.Handler handler, boolean primitive) {
            super(strategy, handler);
            this.primitive = primitive;
        }

        @Override
        public Pipe.Schema<Object> getPipeSchema() {
            return this.pipeSchema;
        }

        protected Object readPrimitiveFrom(Input input, Object owner, int len) throws IOException {
            boolean[] array = new boolean[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            for (int i = 0; i < len; ++i) {
                if (2 != input.readFieldNumber(this)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                array[i] = input.readBool();
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        protected Object readBoxedFrom(Input input, Object owner, int len) throws IOException {
            Boolean[] array = new Boolean[len];
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(array, owner);
            }
            int i = 0;
            block4: while (i < len) {
                switch (input.readFieldNumber(this)) {
                    case 2: {
                        array[i++] = input.readBool();
                        continue block4;
                    }
                    case 3: {
                        i += input.readUInt32();
                        continue block4;
                    }
                }
                throw new ProtostuffException("Corrupt input.");
            }
            if (0 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            return array;
        }

        @Override
        public Object readFrom(Input input, Object owner) throws IOException {
            if (1 != input.readFieldNumber(this)) {
                throw new ProtostuffException("Corrupt input.");
            }
            int len = input.readInt32();
            return this.primitive ? this.readPrimitiveFrom(input, owner, len) : this.readBoxedFrom(input, owner, len);
        }

        protected void writeLengthTo(Output output, int len, boolean primitive) throws IOException {
            output.writeInt32(1, len, false);
        }

        protected void writeTo(Output output, Object value, boolean primitive) throws IOException {
            if (primitive) {
                boolean[] array = (boolean[])value;
                this.writeLengthTo(output, array.length, true);
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    output.writeBool(2, array[i], true);
                }
                return;
            }
            Boolean[] array = (Boolean[])value;
            this.writeLengthTo(output, array.length, false);
            int nullCount = 0;
            for (Boolean v : array) {
                if (v != null) {
                    if (nullCount != 0) {
                        output.writeUInt32(3, nullCount, false);
                        nullCount = 0;
                    }
                    output.writeBool(2, v, true);
                    continue;
                }
                if (!this.allowNullArrayElement) continue;
                ++nullCount;
            }
            if (nullCount != 0) {
                output.writeUInt32(3, nullCount, false);
            }
        }

        @Override
        public void writeTo(Output output, Object value) throws IOException {
            this.writeTo(output, value, this.primitive);
        }
    }

    public static abstract class Base
    extends PolymorphicSchema {
        protected final PolymorphicSchema.Handler handler;
        protected final boolean allowNullArrayElement;

        public Base(IdStrategy strategy, PolymorphicSchema.Handler handler) {
            super(strategy);
            this.handler = handler;
            this.allowNullArrayElement = 0 != (4 & strategy.flags);
        }

        @Override
        public String getFieldName(int number) {
            return ArraySchemas.name(number);
        }

        @Override
        public int getFieldNumber(String name) {
            return ArraySchemas.number(name);
        }

        @Override
        public String messageFullName() {
            return Array.class.getName();
        }

        @Override
        public String messageName() {
            return Array.class.getSimpleName();
        }

        @Override
        protected void setValue(Object value, Object owner) {
            this.handler.setValue(value, owner);
        }

        @Override
        public void mergeFrom(Input input, Object owner) throws IOException {
            this.setValue(this.readFrom(input, owner), owner);
        }

        protected abstract Object readFrom(Input var1, Object var2) throws IOException;
    }
}

