/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.GraphInput;
import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.ProtostuffException;
import io.protostuff.Schema;
import io.protostuff.StatefulOutput;
import io.protostuff.runtime.EnumIO;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.PolymorphicSchema;
import io.protostuff.runtime.RuntimeEnv;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class PolymorphicMapSchema
extends PolymorphicSchema {
    static final int ID_EMPTY_MAP = 1;
    static final int ID_SINGLETON_MAP = 2;
    static final int ID_UNMODIFIABLE_MAP = 3;
    static final int ID_UNMODIFIABLE_SORTED_MAP = 4;
    static final int ID_SYNCHRONIZED_MAP = 5;
    static final int ID_SYNCHRONIZED_SORTED_MAP = 6;
    static final int ID_CHECKED_MAP = 7;
    static final int ID_CHECKED_SORTED_MAP = 8;
    static final String STR_EMPTY_MAP = "a";
    static final String STR_SINGLETON_MAP = "b";
    static final String STR_UNMODIFIABLE_MAP = "c";
    static final String STR_UNMODIFIABLE_SORTED_MAP = "d";
    static final String STR_SYNCHRONIZED_MAP = "e";
    static final String STR_SYNCHRONIZED_SORTED_MAP = "f";
    static final String STR_CHECKED_MAP = "g";
    static final String STR_CHECKED_SORTED_MAP = "h";
    static final IdentityHashMap<Class<?>, Integer> __nonPublicMaps = new IdentityHashMap();
    static final Field fSingletonMap_k;
    static final Field fSingletonMap_v;
    static final Field fUnmodifiableMap_m;
    static final Field fUnmodifiableSortedMap_sm;
    static final Field fSynchronizedMap_m;
    static final Field fSynchronizedSortedMap_sm;
    static final Field fSynchronizedMap_mutex;
    static final Field fCheckedMap_m;
    static final Field fCheckedSortedMap_sm;
    static final Field fCheckedMap_keyType;
    static final Field fCheckedMap_valueType;
    static final RuntimeEnv.Instantiator<?> iSingletonMap;
    static final RuntimeEnv.Instantiator<?> iUnmodifiableMap;
    static final RuntimeEnv.Instantiator<?> iUnmodifiableSortedMap;
    static final RuntimeEnv.Instantiator<?> iSynchronizedMap;
    static final RuntimeEnv.Instantiator<?> iSynchronizedSortedMap;
    static final RuntimeEnv.Instantiator<?> iCheckedMap;
    static final RuntimeEnv.Instantiator<?> iCheckedSortedMap;
    protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

        @Override
        protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
            PolymorphicMapSchema.transferObject(this, pipe, input, output, PolymorphicMapSchema.this.strategy);
        }
    };

    private static Class<?> map(String className, int id) {
        Class clazz = RuntimeEnv.loadClass(className);
        __nonPublicMaps.put(clazz, id);
        return clazz;
    }

    static String name(int number) {
        switch (number) {
            case 1: {
                return STR_EMPTY_MAP;
            }
            case 2: {
                return STR_SINGLETON_MAP;
            }
            case 3: {
                return STR_UNMODIFIABLE_MAP;
            }
            case 4: {
                return STR_UNMODIFIABLE_SORTED_MAP;
            }
            case 5: {
                return STR_SYNCHRONIZED_MAP;
            }
            case 6: {
                return STR_SYNCHRONIZED_SORTED_MAP;
            }
            case 7: {
                return STR_CHECKED_MAP;
            }
            case 8: {
                return STR_CHECKED_SORTED_MAP;
            }
            case 23: {
                return "w";
            }
            case 26: {
                return "z";
            }
        }
        return null;
    }

    static int number(String name) {
        return name.length() != 1 ? 0 : PolymorphicMapSchema.number(name.charAt(0));
    }

    static int number(char c) {
        switch (c) {
            case 'a': {
                return 1;
            }
            case 'b': {
                return 2;
            }
            case 'c': {
                return 3;
            }
            case 'd': {
                return 4;
            }
            case 'e': {
                return 5;
            }
            case 'f': {
                return 6;
            }
            case 'g': {
                return 7;
            }
            case 'h': {
                return 8;
            }
            case 'w': {
                return 23;
            }
            case 'z': {
                return 26;
            }
        }
        return 0;
    }

    public PolymorphicMapSchema(IdStrategy strategy) {
        super(strategy);
    }

    @Override
    public Pipe.Schema<Object> getPipeSchema() {
        return this.pipeSchema;
    }

    @Override
    public String getFieldName(int number) {
        return PolymorphicMapSchema.name(number);
    }

    @Override
    public int getFieldNumber(String name) {
        return PolymorphicMapSchema.number(name);
    }

    @Override
    public String messageFullName() {
        return Collection.class.getName();
    }

    @Override
    public String messageName() {
        return Collection.class.getSimpleName();
    }

    @Override
    public void mergeFrom(Input input, Object owner) throws IOException {
        this.setValue(PolymorphicMapSchema.readObjectFrom(input, this, owner, this.strategy), owner);
    }

    @Override
    public void writeTo(Output output, Object value) throws IOException {
        PolymorphicMapSchema.writeObjectTo(output, value, this, this.strategy);
    }

    static int idFrom(Class<?> clazz) {
        Integer id = __nonPublicMaps.get(clazz);
        if (id == null) {
            throw new RuntimeException("Unknown map: " + clazz);
        }
        return id;
    }

    static Object instanceFrom(int id) {
        switch (id) {
            case 1: {
                return Collections.EMPTY_MAP;
            }
            case 2: {
                return iSingletonMap.newInstance();
            }
            case 3: {
                return iUnmodifiableMap.newInstance();
            }
            case 4: {
                return iUnmodifiableSortedMap.newInstance();
            }
            case 5: {
                return iSynchronizedMap.newInstance();
            }
            case 6: {
                return iSynchronizedSortedMap.newInstance();
            }
            case 7: {
                return iCheckedMap.newInstance();
            }
            case 8: {
                return iCheckedSortedMap.newInstance();
            }
        }
        throw new RuntimeException("Unknown id: " + id);
    }

    static void writeObjectTo(Output output, Object value, Schema<?> currentSchema, IdStrategy strategy) throws IOException {
        if (Collections.class == value.getClass().getDeclaringClass()) {
            PolymorphicMapSchema.writeNonPublicMapTo(output, value, currentSchema, strategy);
            return;
        }
        Class<?> clazz = value.getClass();
        if (EnumMap.class.isAssignableFrom(clazz)) {
            strategy.writeEnumIdTo(output, 23, EnumIO.getKeyTypeFromEnumMap(value));
        } else {
            strategy.writeMapIdTo(output, 26, clazz);
        }
        if (output instanceof StatefulOutput) {
            ((StatefulOutput)output).updateLast(strategy.MAP_SCHEMA, currentSchema);
        }
        strategy.MAP_SCHEMA.writeTo(output, (Map)value);
    }

    static void writeNonPublicMapTo(Output output, Object value, Schema<?> currentSchema, IdStrategy strategy) throws IOException {
        Integer n = __nonPublicMaps.get(value.getClass());
        if (n == null) {
            throw new RuntimeException("Unknown collection: " + value.getClass());
        }
        int id = n;
        switch (id) {
            case 1: {
                output.writeUInt32(id, 0, false);
                break;
            }
            case 2: {
                Object v;
                Object k;
                try {
                    k = fSingletonMap_k.get(value);
                    v = fSingletonMap_v.get(value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                output.writeUInt32(id, 0, false);
                if (k != null) {
                    output.writeObject(1, k, strategy.OBJECT_SCHEMA, false);
                }
                if (v == null) break;
                output.writeObject(3, v, strategy.OBJECT_SCHEMA, false);
                break;
            }
            case 3: {
                PolymorphicMapSchema.writeUnmodifiableMapTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 4: {
                PolymorphicMapSchema.writeUnmodifiableMapTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 5: {
                PolymorphicMapSchema.writeSynchronizedMapTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 6: {
                PolymorphicMapSchema.writeSynchronizedMapTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 7: {
                PolymorphicMapSchema.writeCheckedMapTo(output, value, currentSchema, strategy, id);
                break;
            }
            case 8: {
                PolymorphicMapSchema.writeCheckedMapTo(output, value, currentSchema, strategy, id);
                break;
            }
            default: {
                throw new RuntimeException("Should not happen.");
            }
        }
    }

    private static void writeUnmodifiableMapTo(Output output, Object value, Schema<?> currentSchema, IdStrategy strategy, int id) throws IOException {
        Object m4;
        try {
            m4 = fUnmodifiableMap_m.get(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        output.writeObject(id, m4, strategy.POLYMORPHIC_MAP_SCHEMA, false);
    }

    private static void writeSynchronizedMapTo(Output output, Object value, Schema<?> currentSchema, IdStrategy strategy, int id) throws IOException {
        Object mutex;
        Object m4;
        try {
            m4 = fSynchronizedMap_m.get(value);
            mutex = fSynchronizedMap_mutex.get(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (mutex != value) {
            throw new RuntimeException("This exception is thrown to fail fast. Synchronized collections with a different mutex would only work if graph format is used, since the reference is retained.");
        }
        output.writeObject(id, m4, strategy.POLYMORPHIC_MAP_SCHEMA, false);
    }

    private static void writeCheckedMapTo(Output output, Object value, Schema<?> currentSchema, IdStrategy strategy, int id) throws IOException {
        Object valueType;
        Object keyType;
        Object m4;
        try {
            m4 = fCheckedMap_m.get(value);
            keyType = fCheckedMap_keyType.get(value);
            valueType = fCheckedMap_valueType.get(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        output.writeObject(id, m4, strategy.POLYMORPHIC_MAP_SCHEMA, false);
        output.writeObject(1, keyType, strategy.CLASS_SCHEMA, false);
        output.writeObject(2, valueType, strategy.CLASS_SCHEMA, false);
    }

    static Object readObjectFrom(Input input, Schema<?> schema, Object owner, IdStrategy strategy) throws IOException {
        return PolymorphicMapSchema.readObjectFrom(input, schema, owner, strategy, input.readFieldNumber(schema));
    }

    static Object readObjectFrom(Input input, Schema<?> schema, Object owner, IdStrategy strategy, int number) throws IOException {
        boolean graph = input instanceof GraphInput;
        Object ret = null;
        switch (number) {
            case 1: {
                if (graph) {
                    ((GraphInput)input).updateLast(Collections.EMPTY_MAP, owner);
                }
                if (0 != input.readUInt32()) {
                    throw new ProtostuffException("Corrupt input.");
                }
                ret = Collections.EMPTY_MAP;
                break;
            }
            case 2: {
                Object map = iSingletonMap.newInstance();
                if (graph) {
                    ((GraphInput)input).updateLast(map, owner);
                }
                if (0 != input.readUInt32()) {
                    throw new ProtostuffException("Corrupt input.");
                }
                return PolymorphicMapSchema.fillSingletonMapFrom(input, schema, owner, strategy, graph, map);
            }
            case 3: {
                ret = PolymorphicMapSchema.readUnmodifiableMapFrom(input, schema, owner, strategy, graph, iUnmodifiableMap.newInstance(), false);
                break;
            }
            case 4: {
                ret = PolymorphicMapSchema.readUnmodifiableMapFrom(input, schema, owner, strategy, graph, iUnmodifiableSortedMap.newInstance(), true);
                break;
            }
            case 5: {
                ret = PolymorphicMapSchema.readSynchronizedMapFrom(input, schema, owner, strategy, graph, iSynchronizedMap.newInstance(), false);
                break;
            }
            case 6: {
                ret = PolymorphicMapSchema.readSynchronizedMapFrom(input, schema, owner, strategy, graph, iSynchronizedSortedMap.newInstance(), true);
                break;
            }
            case 7: {
                ret = PolymorphicMapSchema.readCheckedMapFrom(input, schema, owner, strategy, graph, iCheckedMap.newInstance(), false);
                break;
            }
            case 8: {
                ret = PolymorphicMapSchema.readCheckedMapFrom(input, schema, owner, strategy, graph, iCheckedSortedMap.newInstance(), true);
                break;
            }
            case 23: {
                EnumMap em = strategy.resolveEnumFrom(input).newEnumMap();
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast(em, owner);
                }
                strategy.MAP_SCHEMA.mergeFrom(input, em);
                return em;
            }
            case 26: {
                Map map = strategy.resolveMapFrom(input).newMessage();
                if (input instanceof GraphInput) {
                    ((GraphInput)input).updateLast(map, owner);
                }
                strategy.MAP_SCHEMA.mergeFrom(input, map);
                return map;
            }
            default: {
                throw new ProtostuffException("Corrupt input.");
            }
        }
        if (0 != input.readFieldNumber(schema)) {
            throw new ProtostuffException("Corrupt input.");
        }
        return ret;
    }

    private static Object fillSingletonMapFrom(Input input, Schema<?> schema, Object owner, IdStrategy strategy, boolean graph, Object map) throws IOException {
        switch (input.readFieldNumber(schema)) {
            case 0: {
                return map;
            }
            case 1: {
                break;
            }
            case 3: {
                IdStrategy.Wrapper wrapper = new IdStrategy.Wrapper();
                Object v = input.mergeObject(wrapper, strategy.OBJECT_SCHEMA);
                if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
                    v = wrapper.value;
                }
                try {
                    fSingletonMap_v.set(map, v);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (0 != input.readFieldNumber(schema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                return map;
            }
            default: {
                throw new ProtostuffException("Corrupt input.");
            }
        }
        IdStrategy.Wrapper wrapper = new IdStrategy.Wrapper();
        Object k = input.mergeObject(wrapper, strategy.OBJECT_SCHEMA);
        if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
            k = wrapper.value;
        }
        switch (input.readFieldNumber(schema)) {
            case 0: {
                try {
                    fSingletonMap_k.set(map, k);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return map;
            }
            case 3: {
                break;
            }
            default: {
                throw new ProtostuffException("Corrupt input.");
            }
        }
        Object v = input.mergeObject(wrapper, strategy.OBJECT_SCHEMA);
        if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
            v = wrapper.value;
        }
        try {
            fSingletonMap_k.set(map, k);
            fSingletonMap_v.set(map, v);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (0 != input.readFieldNumber(schema)) {
            throw new ProtostuffException("Corrupt input.");
        }
        return map;
    }

    private static Object readUnmodifiableMapFrom(Input input, Schema<?> schema, Object owner, IdStrategy strategy, boolean graph, Object map, boolean sm) throws IOException {
        if (graph) {
            ((GraphInput)input).updateLast(map, owner);
        }
        IdStrategy.Wrapper wrapper = new IdStrategy.Wrapper();
        Object m4 = input.mergeObject(wrapper, strategy.POLYMORPHIC_MAP_SCHEMA);
        if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
            m4 = wrapper.value;
        }
        try {
            fUnmodifiableMap_m.set(map, m4);
            if (sm) {
                fUnmodifiableSortedMap_sm.set(map, m4);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    private static Object readSynchronizedMapFrom(Input input, Schema<?> schema, Object owner, IdStrategy strategy, boolean graph, Object map, boolean sm) throws IOException {
        if (graph) {
            ((GraphInput)input).updateLast(map, owner);
        }
        IdStrategy.Wrapper wrapper = new IdStrategy.Wrapper();
        Object m4 = input.mergeObject(wrapper, strategy.POLYMORPHIC_MAP_SCHEMA);
        if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
            m4 = wrapper.value;
        }
        try {
            fSynchronizedMap_m.set(map, m4);
            fSynchronizedMap_mutex.set(map, map);
            if (sm) {
                fSynchronizedSortedMap_sm.set(map, m4);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    private static Object readCheckedMapFrom(Input input, Schema<?> schema, Object owner, IdStrategy strategy, boolean graph, Object map, boolean sm) throws IOException {
        if (graph) {
            ((GraphInput)input).updateLast(map, owner);
        }
        IdStrategy.Wrapper wrapper = new IdStrategy.Wrapper();
        Object m4 = input.mergeObject(wrapper, strategy.POLYMORPHIC_MAP_SCHEMA);
        if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
            m4 = wrapper.value;
        }
        if (1 != input.readFieldNumber(schema)) {
            throw new ProtostuffException("Corrupt input.");
        }
        Object keyType = input.mergeObject(wrapper, strategy.CLASS_SCHEMA);
        if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
            keyType = wrapper.value;
        }
        if (2 != input.readFieldNumber(schema)) {
            throw new ProtostuffException("Corrupt input.");
        }
        Object valueType = input.mergeObject(wrapper, strategy.CLASS_SCHEMA);
        if (!graph || !((GraphInput)input).isCurrentMessageReference()) {
            valueType = wrapper.value;
        }
        try {
            fCheckedMap_m.set(map, m4);
            fCheckedMap_keyType.set(map, keyType);
            fCheckedMap_valueType.set(map, valueType);
            if (sm) {
                fCheckedSortedMap_sm.set(map, m4);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    static void transferObject(Pipe.Schema<Object> pipeSchema, Pipe pipe, Input input, Output output, IdStrategy strategy) throws IOException {
        PolymorphicMapSchema.transferObject(pipeSchema, pipe, input, output, strategy, input.readFieldNumber(pipeSchema.wrappedSchema));
    }

    static void transferObject(Pipe.Schema<Object> pipeSchema, Pipe pipe, Input input, Output output, IdStrategy strategy, int number) throws IOException {
        switch (number) {
            case 1: {
                output.writeUInt32(number, input.readUInt32(), false);
                break;
            }
            case 2: {
                if (0 != input.readUInt32()) {
                    throw new ProtostuffException("Corrupt input.");
                }
                output.writeUInt32(number, 0, false);
                PolymorphicMapSchema.transferSingletonMap(pipeSchema, pipe, input, output, strategy);
                return;
            }
            case 3: {
                output.writeObject(number, pipe, strategy.POLYMORPHIC_MAP_PIPE_SCHEMA, false);
                break;
            }
            case 4: {
                output.writeObject(number, pipe, strategy.POLYMORPHIC_MAP_PIPE_SCHEMA, false);
                break;
            }
            case 5: {
                output.writeObject(number, pipe, strategy.POLYMORPHIC_MAP_PIPE_SCHEMA, false);
                break;
            }
            case 6: {
                output.writeObject(number, pipe, strategy.POLYMORPHIC_MAP_PIPE_SCHEMA, false);
                break;
            }
            case 7: {
                output.writeObject(number, pipe, strategy.POLYMORPHIC_MAP_PIPE_SCHEMA, false);
                if (1 != input.readFieldNumber(pipeSchema.wrappedSchema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                output.writeObject(1, pipe, strategy.CLASS_PIPE_SCHEMA, false);
                if (2 != input.readFieldNumber(pipeSchema.wrappedSchema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                output.writeObject(2, pipe, strategy.CLASS_PIPE_SCHEMA, false);
                break;
            }
            case 8: {
                output.writeObject(number, pipe, strategy.POLYMORPHIC_MAP_PIPE_SCHEMA, false);
                if (1 != input.readFieldNumber(pipeSchema.wrappedSchema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                output.writeObject(1, pipe, strategy.CLASS_PIPE_SCHEMA, false);
                if (2 != input.readFieldNumber(pipeSchema.wrappedSchema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                output.writeObject(2, pipe, strategy.CLASS_PIPE_SCHEMA, false);
                break;
            }
            case 23: {
                strategy.transferEnumId(input, output, number);
                if (output instanceof StatefulOutput) {
                    ((StatefulOutput)output).updateLast(strategy.MAP_PIPE_SCHEMA, pipeSchema);
                }
                Pipe.transferDirect(strategy.MAP_PIPE_SCHEMA, pipe, input, output);
                return;
            }
            case 26: {
                strategy.transferMapId(input, output, number);
                if (output instanceof StatefulOutput) {
                    ((StatefulOutput)output).updateLast(strategy.MAP_PIPE_SCHEMA, pipeSchema);
                }
                Pipe.transferDirect(strategy.MAP_PIPE_SCHEMA, pipe, input, output);
                return;
            }
            default: {
                throw new ProtostuffException("Corrupt input.");
            }
        }
        if (0 != input.readFieldNumber(pipeSchema.wrappedSchema)) {
            throw new ProtostuffException("Corrupt input.");
        }
    }

    static void transferSingletonMap(Pipe.Schema<Object> pipeSchema, Pipe pipe, Input input, Output output, IdStrategy strategy) throws IOException {
        switch (input.readFieldNumber(pipeSchema.wrappedSchema)) {
            case 0: {
                return;
            }
            case 1: {
                break;
            }
            case 3: {
                output.writeObject(3, pipe, strategy.OBJECT_PIPE_SCHEMA, false);
                if (0 != input.readFieldNumber(pipeSchema.wrappedSchema)) {
                    throw new ProtostuffException("Corrupt input.");
                }
                return;
            }
            default: {
                throw new ProtostuffException("Corrupt input.");
            }
        }
        output.writeObject(1, pipe, strategy.OBJECT_PIPE_SCHEMA, false);
        switch (input.readFieldNumber(pipeSchema.wrappedSchema)) {
            case 0: {
                return;
            }
            case 3: {
                break;
            }
            default: {
                throw new ProtostuffException("Corrupt input.");
            }
        }
        output.writeObject(3, pipe, strategy.OBJECT_PIPE_SCHEMA, false);
        if (0 != input.readFieldNumber(pipeSchema.wrappedSchema)) {
            throw new ProtostuffException("Corrupt input.");
        }
    }

    static {
        PolymorphicMapSchema.map("java.util.Collections$EmptyMap", 1);
        Class<?> cSingletonMap = PolymorphicMapSchema.map("java.util.Collections$SingletonMap", 2);
        Class<?> cUnmodifiableMap = PolymorphicMapSchema.map("java.util.Collections$UnmodifiableMap", 3);
        Class<?> cUnmodifiableSortedMap = PolymorphicMapSchema.map("java.util.Collections$UnmodifiableSortedMap", 4);
        Class<?> cSynchronizedMap = PolymorphicMapSchema.map("java.util.Collections$SynchronizedMap", 5);
        Class<?> cSynchronizedSortedMap = PolymorphicMapSchema.map("java.util.Collections$SynchronizedSortedMap", 6);
        Class<?> cCheckedMap = PolymorphicMapSchema.map("java.util.Collections$CheckedMap", 7);
        Class<?> cCheckedSortedMap = PolymorphicMapSchema.map("java.util.Collections$CheckedSortedMap", 8);
        try {
            fSingletonMap_k = cSingletonMap.getDeclaredField("k");
            fSingletonMap_v = cSingletonMap.getDeclaredField("v");
            fUnmodifiableMap_m = cUnmodifiableMap.getDeclaredField("m");
            fUnmodifiableSortedMap_sm = cUnmodifiableSortedMap.getDeclaredField("sm");
            fSynchronizedMap_m = cSynchronizedMap.getDeclaredField("m");
            fSynchronizedSortedMap_sm = cSynchronizedSortedMap.getDeclaredField("sm");
            fSynchronizedMap_mutex = cSynchronizedMap.getDeclaredField("mutex");
            fCheckedMap_m = cCheckedMap.getDeclaredField("m");
            fCheckedSortedMap_sm = cCheckedSortedMap.getDeclaredField("sm");
            fCheckedMap_keyType = cCheckedMap.getDeclaredField("keyType");
            fCheckedMap_valueType = cCheckedMap.getDeclaredField("valueType");
            iSingletonMap = RuntimeEnv.newInstantiator(cSingletonMap);
            iUnmodifiableMap = RuntimeEnv.newInstantiator(cUnmodifiableMap);
            iUnmodifiableSortedMap = RuntimeEnv.newInstantiator(cUnmodifiableSortedMap);
            iSynchronizedMap = RuntimeEnv.newInstantiator(cSynchronizedMap);
            iSynchronizedSortedMap = RuntimeEnv.newInstantiator(cSynchronizedSortedMap);
            iCheckedMap = RuntimeEnv.newInstantiator(cCheckedMap);
            iCheckedSortedMap = RuntimeEnv.newInstantiator(cCheckedSortedMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        fSingletonMap_k.setAccessible(true);
        fSingletonMap_v.setAccessible(true);
        fUnmodifiableMap_m.setAccessible(true);
        fUnmodifiableSortedMap_sm.setAccessible(true);
        fSynchronizedMap_m.setAccessible(true);
        fSynchronizedSortedMap_sm.setAccessible(true);
        fSynchronizedMap_mutex.setAccessible(true);
        fCheckedMap_m.setAccessible(true);
        fCheckedSortedMap_sm.setAccessible(true);
        fCheckedMap_keyType.setAccessible(true);
        fCheckedMap_valueType.setAccessible(true);
    }
}

