/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public class ThreadTrackingGroup
extends ThreadGroup {
    private final ThreadLifecycleListener listener;

    public ThreadTrackingGroup(ThreadGroup parent, ThreadLifecycleListener listener) {
        super(parent, ThreadTrackingGroup.class.getSimpleName().toLowerCase() + System.identityHashCode(listener));
        this.listener = listener;
    }

    void add(Thread t2) {
        super.add(t2);
        this.listener.started(t2);
    }

    void threadStartFailed(Thread t2) {
        super.threadStartFailed(t2);
        this.listener.startFailed(t2);
    }

    void threadTerminated(Thread t2) {
        super.threadTerminated(t2);
        this.listener.terminated(t2);
    }
}

