/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client;

import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.client.DataStreamClientFactory;
import org.apache.ratis.client.DataStreamClientRpc;
import org.apache.ratis.client.DataStreamRpcApi;
import org.apache.ratis.client.impl.ClientImplUtils;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.datastream.SupportedDataStreamType;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DataStreamClient
extends DataStreamRpcApi,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(DataStreamClient.class);

    public DataStreamClientRpc getClientRpc();

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private RaftPeer dataStreamServer;
        private DataStreamClientRpc dataStreamClientRpc;
        private RaftProperties properties;
        private Parameters parameters;
        private RaftGroupId raftGroupId;
        private ClientId clientId;

        private Builder() {
        }

        public DataStreamClient build() {
            Objects.requireNonNull(this.dataStreamServer, "The 'dataStreamServer' field is not initialized.");
            if (this.properties != null && this.dataStreamClientRpc == null) {
                SupportedDataStreamType type = RaftConfigKeys.DataStream.type(this.properties, LOG::info);
                this.dataStreamClientRpc = DataStreamClientFactory.newInstance(type, this.parameters).newDataStreamClientRpc(this.dataStreamServer, this.properties);
            }
            return ClientImplUtils.newDataStreamClient(Optional.ofNullable(this.clientId).orElseGet(ClientId::randomId), this.raftGroupId, this.dataStreamServer, this.dataStreamClientRpc, this.properties);
        }

        public Builder setClientId(ClientId clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setRaftGroupId(RaftGroupId raftGroupId) {
            this.raftGroupId = raftGroupId;
            return this;
        }

        public Builder setDataStreamServer(RaftPeer dataStreamServer) {
            this.dataStreamServer = dataStreamServer;
            return this;
        }

        public Builder setDataStreamClientRpc(DataStreamClientRpc dataStreamClientRpc) {
            this.dataStreamClientRpc = dataStreamClientRpc;
            return this;
        }

        public Builder setParameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder setProperties(RaftProperties properties) {
            this.properties = properties;
            return this;
        }
    }
}

