/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.client.AsyncRpcApi;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.client.impl.RaftClientImpl;
import org.apache.ratis.client.impl.UnorderedAsync;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeerId;

class AsyncImpl
implements AsyncRpcApi {
    private final RaftClientImpl client;

    AsyncImpl(RaftClientImpl client) {
        this.client = Objects.requireNonNull(client, "client == null");
    }

    CompletableFuture<RaftClientReply> send(RaftClientRequest.Type type, Message message, RaftPeerId server) {
        return this.client.getOrderedAsync().send(type, message, server);
    }

    @Override
    public CompletableFuture<RaftClientReply> send(Message message) {
        return this.send(RaftClientRequest.writeRequestType(), message, null);
    }

    @Override
    public CompletableFuture<RaftClientReply> sendReadOnly(Message message, RaftPeerId server) {
        return this.send(RaftClientRequest.readRequestType(), message, server);
    }

    @Override
    public CompletableFuture<RaftClientReply> sendReadOnlyNonLinearizable(Message message) {
        return this.send(RaftClientRequest.readRequestType(true), message, null);
    }

    @Override
    public CompletableFuture<RaftClientReply> sendReadOnlyUnordered(Message message, RaftPeerId server) {
        return UnorderedAsync.send(RaftClientRequest.readRequestType(), message, server, this.client);
    }

    @Override
    public CompletableFuture<RaftClientReply> sendStaleRead(Message message, long minIndex, RaftPeerId server) {
        return this.send(RaftClientRequest.staleReadRequestType(minIndex), message, server);
    }

    @Override
    public CompletableFuture<RaftClientReply> watch(long index, RaftProtos.ReplicationLevel replication) {
        return UnorderedAsync.send(RaftClientRequest.watchRequestType(index, replication), null, null, this.client);
    }

    @Override
    public CompletableFuture<RaftClientReply> sendForward(RaftClientRequest request) {
        RaftProtos.RaftClientRequestProto proto = ClientProtoUtils.toRaftClientRequestProto(request);
        return this.send(RaftClientRequest.forwardRequestType(), Message.valueOf(proto.toByteString()), null);
    }
}

