/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.ratis.client.api.GroupManagementApi;
import org.apache.ratis.client.impl.RaftClientImpl;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.CallId;
import org.apache.ratis.util.Preconditions;

class GroupManagementImpl
implements GroupManagementApi {
    private final RaftPeerId server;
    private final RaftClientImpl client;

    GroupManagementImpl(RaftPeerId server, RaftClientImpl client) {
        this.server = Objects.requireNonNull(server, "server == null");
        this.client = Objects.requireNonNull(client, "client == null");
    }

    @Override
    public RaftClientReply add(RaftGroup newGroup) throws IOException {
        Objects.requireNonNull(newGroup, "newGroup == null");
        long callId = CallId.getAndIncrement();
        this.client.getClientRpc().addRaftPeers(newGroup.getPeers());
        return this.client.io().sendRequestWithRetry(() -> GroupManagementRequest.newAdd(this.client.getId(), this.server, callId, newGroup));
    }

    @Override
    public RaftClientReply remove(RaftGroupId groupId, boolean deleteDirectory, boolean renameDirectory) throws IOException {
        Objects.requireNonNull(groupId, "groupId == null");
        long callId = CallId.getAndIncrement();
        return this.client.io().sendRequestWithRetry(() -> GroupManagementRequest.newRemove(this.client.getId(), this.server, callId, groupId, deleteDirectory, renameDirectory));
    }

    @Override
    public GroupListReply list() throws IOException {
        long callId = CallId.getAndIncrement();
        RaftClientReply reply = this.client.io().sendRequestWithRetry(() -> new GroupListRequest(this.client.getId(), this.server, this.client.getGroupId(), callId));
        Preconditions.assertTrue(reply instanceof GroupListReply, () -> "Unexpected reply: " + reply);
        return (GroupListReply)reply;
    }

    @Override
    public GroupInfoReply info(RaftGroupId groupId) throws IOException {
        RaftGroupId gid = groupId != null ? groupId : this.client.getGroupId();
        long callId = CallId.getAndIncrement();
        RaftClientReply reply = this.client.io().sendRequestWithRetry(() -> new GroupInfoRequest(this.client.getId(), this.server, gid, callId));
        Preconditions.assertTrue(reply instanceof GroupInfoReply, () -> "Unexpected reply: " + reply);
        return (GroupInfoReply)reply;
    }
}

