/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.Objects;

public class MetricRegistryInfo {
    private final String prefix;
    private final String metricsDescription;
    private final String metricsComponentName;
    private final String fullName;
    private final String applicationName;

    public MetricRegistryInfo(String prefix, String applicationName, String metricsComponentName, String metricsDescription) {
        this.prefix = prefix;
        this.applicationName = applicationName;
        this.metricsComponentName = metricsComponentName;
        this.metricsDescription = metricsDescription;
        this.fullName = MetricRegistry.name(applicationName, metricsComponentName, prefix);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getMetricsComponentName() {
        return this.metricsComponentName;
    }

    public String getMetricsDescription() {
        return this.metricsDescription;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MetricRegistryInfo) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.metricsDescription, this.metricsComponentName);
    }

    public String getName() {
        return this.fullName;
    }
}

