/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ratis.datastream.impl.DataStreamReplyByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamRequestByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamRequestFilePositionCount;
import org.apache.ratis.io.FilePositionCount;
import org.apache.ratis.io.StandardWriteOption;
import org.apache.ratis.io.WriteOption;
import org.apache.ratis.netty.server.DataStreamRequestByteBuf;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.DataStreamPacketHeader;
import org.apache.ratis.protocol.DataStreamReplyHeader;
import org.apache.ratis.protocol.DataStreamRequest;
import org.apache.ratis.protocol.DataStreamRequestHeader;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.ratis.thirdparty.io.netty.buffer.Unpooled;
import org.apache.ratis.thirdparty.io.netty.channel.DefaultFileRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NettyDataStreamUtils {
    public static final Logger LOG = LoggerFactory.getLogger(NettyDataStreamUtils.class);

    public static ByteBuffer getDataStreamRequestHeaderProtoByteBuffer(DataStreamRequest request) {
        RaftProtos.DataStreamPacketHeaderProto.Builder b = RaftProtos.DataStreamPacketHeaderProto.newBuilder().setClientId(request.getClientId().toByteString()).setStreamId(request.getStreamId()).setStreamOffset(request.getStreamOffset()).setType(request.getType()).setDataLength(request.getDataLength());
        for (WriteOption option : request.getWriteOptionList()) {
            b.addOptions(RaftProtos.DataStreamPacketHeaderProto.Option.forNumber(((StandardWriteOption)option).ordinal()));
        }
        return RaftProtos.DataStreamRequestHeaderProto.newBuilder().setPacketHeader(b).build().toByteString().asReadOnlyByteBuffer();
    }

    public static ByteBuffer getDataStreamReplyHeaderProtoByteBuf(DataStreamReplyByteBuffer reply) {
        RaftProtos.DataStreamPacketHeaderProto.Builder b = RaftProtos.DataStreamPacketHeaderProto.newBuilder().setClientId(reply.getClientId().toByteString()).setStreamId(reply.getStreamId()).setStreamOffset(reply.getStreamOffset()).setType(reply.getType()).setDataLength(reply.getDataLength());
        return RaftProtos.DataStreamReplyHeaderProto.newBuilder().setPacketHeader(b).setBytesWritten(reply.getBytesWritten()).setSuccess(reply.isSuccess()).addAllCommitInfos(reply.getCommitInfos()).build().toByteString().asReadOnlyByteBuffer();
    }

    public static void encodeDataStreamRequestHeader(DataStreamRequest request, Consumer<Object> out, ByteBufAllocator allocator) {
        ByteBuffer headerBuf = NettyDataStreamUtils.getDataStreamRequestHeaderProtoByteBuffer(request);
        ByteBuf headerBodyLenBuf = allocator.directBuffer(DataStreamPacketHeader.getSizeOfHeaderBodyLen());
        headerBodyLenBuf.writeLong((long)headerBuf.remaining() + request.getDataLength());
        out.accept(headerBodyLenBuf);
        ByteBuf headerLenBuf = allocator.directBuffer(DataStreamPacketHeader.getSizeOfHeaderLen());
        headerLenBuf.writeInt(headerBuf.remaining());
        out.accept(headerLenBuf);
        out.accept(Unpooled.wrappedBuffer(headerBuf));
    }

    public static void encodeDataStreamRequestByteBuffer(DataStreamRequestByteBuffer request, Consumer<Object> out, ByteBufAllocator allocator) {
        NettyDataStreamUtils.encodeDataStreamRequestHeader(request, out, allocator);
        NettyDataStreamUtils.encodeByteBuffer(request.slice(), out);
    }

    public static void encodeByteBuffer(ByteBuffer buffer, Consumer<Object> out) {
        if (buffer.remaining() == 0) {
            out.accept(Unpooled.EMPTY_BUFFER);
            return;
        }
        out.accept(Unpooled.wrappedBuffer(buffer));
    }

    public static void encodeDataStreamRequestFilePositionCount(DataStreamRequestFilePositionCount request, Consumer<Object> out, ByteBufAllocator allocator) {
        NettyDataStreamUtils.encodeDataStreamRequestHeader(request, out, allocator);
        FilePositionCount f = request.getFile();
        out.accept(new DefaultFileRegion(f.getFile(), f.getPosition(), f.getCount()));
    }

    public static void encodeDataStreamReplyByteBuffer(DataStreamReplyByteBuffer reply, Consumer<ByteBuf> out, ByteBufAllocator allocator) {
        ByteBuffer headerBuf = NettyDataStreamUtils.getDataStreamReplyHeaderProtoByteBuf(reply);
        ByteBuf headerLenBuf = allocator.directBuffer(DataStreamPacketHeader.getSizeOfHeaderLen());
        headerLenBuf.writeInt(headerBuf.remaining());
        out.accept(headerLenBuf);
        out.accept(Unpooled.wrappedBuffer(headerBuf));
        out.accept(Unpooled.wrappedBuffer(reply.slice()));
    }

    public static DataStreamRequestByteBuf decodeDataStreamRequestByteBuf(ByteBuf buf) {
        return Optional.ofNullable(NettyDataStreamUtils.decodeDataStreamRequestHeader(buf)).map(header -> NettyDataStreamUtils.checkHeader(header, buf)).map(header -> new DataStreamRequestByteBuf((DataStreamRequestHeader)header, NettyDataStreamUtils.decodeData(buf, header, ByteBuf::retain))).orElse(null);
    }

    public static DataStreamRequestHeader decodeDataStreamRequestHeader(ByteBuf buf) {
        if (DataStreamPacketHeader.getSizeOfHeaderBodyLen() > buf.readableBytes()) {
            return null;
        }
        long headerBodyBufLen = buf.readLong();
        if (headerBodyBufLen > (long)buf.readableBytes()) {
            buf.resetReaderIndex();
            return null;
        }
        int headerBufLen = buf.readInt();
        if (headerBufLen > buf.readableBytes()) {
            buf.resetReaderIndex();
            return null;
        }
        try {
            ByteBuf headerBuf = buf.slice(buf.readerIndex(), headerBufLen);
            RaftProtos.DataStreamRequestHeaderProto header = RaftProtos.DataStreamRequestHeaderProto.parseFrom(headerBuf.nioBuffer());
            RaftProtos.DataStreamPacketHeaderProto h2 = header.getPacketHeader();
            if (h2.getDataLength() + (long)headerBufLen <= (long)buf.readableBytes()) {
                buf.readerIndex(buf.readerIndex() + headerBufLen);
                WriteOption[] options = new WriteOption[h2.getOptionsCount()];
                for (int i = 0; i < options.length; ++i) {
                    options[i] = StandardWriteOption.values()[h2.getOptions(i).ordinal()];
                }
                return new DataStreamRequestHeader(ClientId.valueOf(h2.getClientId()), h2.getType(), h2.getStreamId(), h2.getStreamOffset(), h2.getDataLength(), options);
            }
            buf.resetReaderIndex();
            return null;
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Fail to decode request header:", e);
            buf.resetReaderIndex();
            return null;
        }
    }

    public static ByteBuffer copy(ByteBuf buf) {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return ByteBuffer.wrap(bytes);
    }

    public static DataStreamReplyByteBuffer decodeDataStreamReplyByteBuffer(ByteBuf buf) {
        return Optional.ofNullable(NettyDataStreamUtils.decodeDataStreamReplyHeader(buf)).map(header -> NettyDataStreamUtils.checkHeader(header, buf)).map(header -> DataStreamReplyByteBuffer.newBuilder().setDataStreamReplyHeader((DataStreamReplyHeader)header).setBuffer(NettyDataStreamUtils.decodeData(buf, header, NettyDataStreamUtils::copy)).build()).orElse(null);
    }

    public static DataStreamReplyHeader decodeDataStreamReplyHeader(ByteBuf buf) {
        if (DataStreamPacketHeader.getSizeOfHeaderLen() > buf.readableBytes()) {
            return null;
        }
        int headerBufLen = buf.readInt();
        if (headerBufLen > buf.readableBytes()) {
            buf.resetReaderIndex();
            return null;
        }
        try {
            ByteBuf headerBuf = buf.slice(buf.readerIndex(), headerBufLen);
            RaftProtos.DataStreamReplyHeaderProto header = RaftProtos.DataStreamReplyHeaderProto.parseFrom(headerBuf.nioBuffer());
            RaftProtos.DataStreamPacketHeaderProto h2 = header.getPacketHeader();
            if (header.getPacketHeader().getDataLength() + (long)headerBufLen <= (long)buf.readableBytes()) {
                buf.readerIndex(buf.readerIndex() + headerBufLen);
                return new DataStreamReplyHeader(ClientId.valueOf(h2.getClientId()), h2.getType(), h2.getStreamId(), h2.getStreamOffset(), h2.getDataLength(), header.getBytesWritten(), header.getSuccess(), header.getCommitInfosList());
            }
            buf.resetReaderIndex();
            return null;
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Fail to decode reply header:", e);
            buf.resetReaderIndex();
            return null;
        }
    }

    public static <HEADER extends DataStreamPacketHeader> HEADER checkHeader(HEADER header, ByteBuf buf) {
        if (header == null) {
            return null;
        }
        if ((long)buf.readableBytes() < header.getDataLength()) {
            buf.resetReaderIndex();
            return null;
        }
        return header;
    }

    public static <DATA> DATA decodeData(ByteBuf buf, DataStreamPacketHeader header, Function<ByteBuf, DATA> toData) {
        DATA data;
        int dataLength = Math.toIntExact(header.getDataLength());
        if (dataLength > 0) {
            data = toData.apply(buf.slice(buf.readerIndex(), dataLength));
            buf.readerIndex(buf.readerIndex() + dataLength);
        } else {
            data = null;
        }
        buf.markReaderIndex();
        return data;
    }
}

