/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty;

import java.security.PrivateKey;
import java.util.function.Function;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.ratis.security.TlsConf;
import org.apache.ratis.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.channel.epoll.Epoll;
import org.apache.ratis.thirdparty.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContext;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ratis.util.ConcurrentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NettyUtils {
    public static final Logger LOG = LoggerFactory.getLogger(NettyUtils.class);

    public static EventLoopGroup newEventLoopGroup(String name, int size, boolean useEpoll) {
        if (useEpoll) {
            if (Epoll.isAvailable()) {
                LOG.info("Create EpollEventLoopGroup for {}; Thread size is {}.", (Object)name, (Object)size);
                return new EpollEventLoopGroup(size, ConcurrentUtils.newThreadFactory(name + "-"));
            }
            LOG.warn("Failed to create EpollEventLoopGroup for " + name + "; fall back on NioEventLoopGroup.", Epoll.unavailabilityCause());
        }
        return new NioEventLoopGroup(size, ConcurrentUtils.newThreadFactory(name + "-"));
    }

    public static void setTrustManager(SslContextBuilder b, TlsConf.TrustManagerConf trustManagerConfig) {
        if (trustManagerConfig == null) {
            return;
        }
        TrustManager trustManager = trustManagerConfig.getTrustManager();
        if (trustManager != null) {
            b.trustManager(trustManager);
            return;
        }
        TlsConf.CertificatesConf certificates = trustManagerConfig.getTrustCertificates();
        if (certificates.isFileBased()) {
            b.trustManager(certificates.getFile());
        } else {
            b.trustManager((Iterable)certificates.get());
        }
    }

    public static void setKeyManager(SslContextBuilder b, TlsConf.KeyManagerConf keyManagerConfig) {
        if (keyManagerConfig == null) {
            return;
        }
        KeyManager keyManager = keyManagerConfig.getKeyManager();
        if (keyManager != null) {
            b.keyManager(keyManager);
            return;
        }
        TlsConf.PrivateKeyConf privateKey = keyManagerConfig.getPrivateKey();
        TlsConf.CertificatesConf certificates = keyManagerConfig.getKeyCertificates();
        if (keyManagerConfig.isFileBased()) {
            b.keyManager(certificates.getFile(), privateKey.getFile());
        } else {
            b.keyManager((PrivateKey)privateKey.get(), (Iterable)certificates.get());
        }
    }

    public static SslContextBuilder initSslContextBuilderForServer(TlsConf.KeyManagerConf keyManagerConfig) {
        KeyManager keyManager = keyManagerConfig.getKeyManager();
        if (keyManager != null) {
            return SslContextBuilder.forServer(keyManager);
        }
        TlsConf.PrivateKeyConf privateKey = keyManagerConfig.getPrivateKey();
        TlsConf.CertificatesConf certificates = keyManagerConfig.getKeyCertificates();
        if (keyManagerConfig.isFileBased()) {
            return SslContextBuilder.forServer(certificates.getFile(), privateKey.getFile());
        }
        return SslContextBuilder.forServer((PrivateKey)privateKey.get(), (Iterable)certificates.get());
    }

    public static SslContextBuilder initSslContextBuilderForServer(TlsConf tlsConf) {
        SslContextBuilder b = NettyUtils.initSslContextBuilderForServer(tlsConf.getKeyManager());
        if (tlsConf.isMutualTls()) {
            NettyUtils.setTrustManager(b, tlsConf.getTrustManager());
        }
        return b;
    }

    public static SslContext buildSslContextForServer(TlsConf tlsConf) {
        return NettyUtils.buildSslContext("server", tlsConf, NettyUtils::initSslContextBuilderForServer);
    }

    public static SslContextBuilder initSslContextBuilderForClient(TlsConf tlsConf) {
        SslContextBuilder b = SslContextBuilder.forClient();
        NettyUtils.setTrustManager(b, tlsConf.getTrustManager());
        if (tlsConf.isMutualTls()) {
            NettyUtils.setKeyManager(b, tlsConf.getKeyManager());
        }
        return b;
    }

    public static SslContext buildSslContextForClient(TlsConf tlsConf) {
        return NettyUtils.buildSslContext("client", tlsConf, NettyUtils::initSslContextBuilderForClient);
    }

    public static SslContext buildSslContext(String name, TlsConf tlsConf, Function<TlsConf, SslContextBuilder> builder) {
        SslContext sslContext;
        if (tlsConf == null) {
            return null;
        }
        try {
            sslContext = builder.apply(tlsConf).build();
        }
        catch (Exception e) {
            String message = "Failed to buildSslContext for " + name + " from " + tlsConf;
            throw new IllegalArgumentException(message, e);
        }
        LOG.debug("buildSslContext for {} from {} returns {}", name, tlsConf, sslContext.getClass().getName());
        return sslContext;
    }
}

