/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty.metrics;

import com.codahale.metrics.Timer;
import java.util.Locale;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.RatisMetrics;

public class NettyServerStreamRpcMetrics
extends RatisMetrics {
    private static final String METRICS_APP_NAME = "ratis_netty";
    private static final String METRICS_COMP_NAME = "stream_server";
    private static final String METRICS_DESC = "Metrics for Ratis Netty Stream Server";
    private static final String METRICS_LATENCY = "%s_latency";
    private static final String METRICS_SUCCESS = "%s_success_reply_count";
    private static final String METRICS_FAIL = "%s_fail_reply_count";
    private static final String METRICS_NUM_REQUESTS = "num_requests_%s";

    public NettyServerStreamRpcMetrics(String serverId) {
        this.registry = this.getMetricRegistryForGrpcServer(serverId);
    }

    private RatisMetricRegistry getMetricRegistryForGrpcServer(String serverId) {
        return NettyServerStreamRpcMetrics.create(new MetricRegistryInfo(serverId, METRICS_APP_NAME, METRICS_COMP_NAME, METRICS_DESC));
    }

    public RequestMetrics newRequestMetrics(RequestType type) {
        return new RequestMetrics(type);
    }

    public Timer getLatencyTimer(RequestType type) {
        return this.registry.timer(type.getLatencyString());
    }

    public void onRequestCreate(RequestType type) {
        this.registry.counter(type.getNumRequestsString()).inc();
    }

    public void onRequestSuccess(RequestType type) {
        this.registry.counter(type.getSuccessCountString()).inc();
    }

    public void onRequestFail(RequestType type) {
        this.registry.counter(type.getFailCountString()).inc();
    }

    public final class RequestMetrics {
        private final RequestType type;
        private final Timer timer;

        private RequestMetrics(RequestType type) {
            this.type = type;
            this.timer = NettyServerStreamRpcMetrics.this.getLatencyTimer(type);
        }

        public RequestContext start() {
            NettyServerStreamRpcMetrics.this.onRequestCreate(this.type);
            return new RequestContext(this.timer.time());
        }

        public void stop(RequestContext context, boolean success) {
            context.getTimerContext().stop();
            if (success) {
                NettyServerStreamRpcMetrics.this.onRequestSuccess(this.type);
            } else {
                NettyServerStreamRpcMetrics.this.onRequestFail(this.type);
            }
        }
    }

    public static final class RequestContext {
        private final Timer.Context timerContext;

        private RequestContext(Timer.Context timerContext) {
            this.timerContext = timerContext;
        }

        Timer.Context getTimerContext() {
            return this.timerContext;
        }
    }

    public static enum RequestType {
        CHANNEL_READ,
        HEADER,
        LOCAL_WRITE,
        REMOTE_WRITE,
        STATE_MACHINE_STREAM,
        START_TRANSACTION;

        private final String numRequestsString;
        private final String successCountString;
        private final String failCountString;
        private final String latencyString;

        private RequestType() {
            String lower = this.name().toLowerCase(Locale.ENGLISH);
            this.numRequestsString = String.format(NettyServerStreamRpcMetrics.METRICS_NUM_REQUESTS, lower);
            this.successCountString = String.format(NettyServerStreamRpcMetrics.METRICS_SUCCESS, lower);
            this.failCountString = String.format(NettyServerStreamRpcMetrics.METRICS_FAIL, lower);
            this.latencyString = String.format(NettyServerStreamRpcMetrics.METRICS_LATENCY, lower);
        }

        String getNumRequestsString() {
            return this.numRequestsString;
        }

        String getSuccessCountString() {
            return this.successCountString;
        }

        String getFailCountString() {
            return this.failCountString;
        }

        String getLatencyString() {
            return this.latencyString;
        }
    }
}

