/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty.server;

import java.util.Collections;
import java.util.List;
import org.apache.ratis.datastream.impl.DataStreamPacketImpl;
import org.apache.ratis.io.WriteOption;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.DataStreamRequest;
import org.apache.ratis.protocol.DataStreamRequestHeader;
import org.apache.ratis.thirdparty.com.google.common.collect.Lists;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.thirdparty.io.netty.buffer.Unpooled;

public class DataStreamRequestByteBuf
extends DataStreamPacketImpl
implements DataStreamRequest {
    private final ByteBuf buf;
    private final List<WriteOption> options;

    public DataStreamRequestByteBuf(ClientId clientId, RaftProtos.DataStreamPacketHeaderProto.Type type, long streamId, long streamOffset, Iterable<WriteOption> options, ByteBuf buf) {
        super(clientId, type, streamId, streamOffset);
        this.buf = buf != null ? buf.asReadOnly() : Unpooled.EMPTY_BUFFER;
        this.options = Collections.unmodifiableList(Lists.newArrayList(options));
    }

    public DataStreamRequestByteBuf(DataStreamRequestHeader header, ByteBuf buf) {
        this(header.getClientId(), header.getType(), header.getStreamId(), header.getStreamOffset(), header.getWriteOptionList(), buf);
    }

    @Override
    public long getDataLength() {
        return this.buf.readableBytes();
    }

    public ByteBuf slice() {
        return this.buf.slice();
    }

    @Override
    public List<WriteOption> getWriteOptionList() {
        return this.options;
    }
}

