/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.server.raftlog.RaftLogIndex;
import org.apache.ratis.util.Timestamp;

class FollowerInfoImpl
implements FollowerInfo {
    private final String name;
    private final Consumer<Object> infoIndexChange;
    private final Consumer<Object> debugIndexChange;
    private final AtomicReference<RaftPeer> peer;
    private final Function<RaftPeerId, RaftPeer> getPeer;
    private final AtomicReference<Timestamp> lastRpcResponseTime;
    private final AtomicReference<Timestamp> lastRpcSendTime;
    private final AtomicReference<Timestamp> lastHeartbeatSendTime;
    private final RaftLogIndex nextIndex;
    private final RaftLogIndex matchIndex = new RaftLogIndex("matchIndex", -1L);
    private final RaftLogIndex commitIndex = new RaftLogIndex("commitIndex", -1L);
    private final RaftLogIndex snapshotIndex = new RaftLogIndex("snapshotIndex", 0L);
    private volatile boolean caughtUp;
    private volatile boolean ackInstallSnapshotAttempt = false;

    FollowerInfoImpl(RaftGroupMemberId id, RaftPeer peer, Function<RaftPeerId, RaftPeer> getPeer, Timestamp lastRpcTime, long nextIndex, boolean caughtUp) {
        this.name = id + "->" + peer.getId();
        this.infoIndexChange = s2 -> LOG.info("{}: {}", (Object)this.name, s2);
        this.debugIndexChange = s2 -> LOG.debug("{}: {}", (Object)this.name, s2);
        this.peer = new AtomicReference<RaftPeer>(peer);
        this.getPeer = getPeer;
        this.lastRpcResponseTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.lastRpcSendTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.lastHeartbeatSendTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.nextIndex = new RaftLogIndex("nextIndex", nextIndex);
        this.caughtUp = caughtUp;
    }

    @Override
    public long getMatchIndex() {
        return this.matchIndex.get();
    }

    @Override
    public boolean updateMatchIndex(long newMatchIndex) {
        return this.matchIndex.updateToMax(newMatchIndex, this.debugIndexChange);
    }

    @Override
    public long getCommitIndex() {
        return this.commitIndex.get();
    }

    @Override
    public boolean updateCommitIndex(long newCommitIndex) {
        return this.commitIndex.updateToMax(newCommitIndex, this.debugIndexChange);
    }

    @Override
    public long getSnapshotIndex() {
        return this.snapshotIndex.get();
    }

    @Override
    public long getNextIndex() {
        return this.nextIndex.get();
    }

    @Override
    public void increaseNextIndex(long newNextIndex) {
        this.nextIndex.updateIncreasingly(newNextIndex, this.debugIndexChange);
    }

    @Override
    public void decreaseNextIndex(long newNextIndex) {
        this.nextIndex.updateUnconditionally(old -> old <= 0L ? old : Math.min(old - 1L, newNextIndex), message -> this.infoIndexChange.accept("decreaseNextIndex " + message));
    }

    @Override
    public void setNextIndex(long newNextIndex) {
        this.nextIndex.updateUnconditionally(old -> newNextIndex >= 0L ? newNextIndex : old, message -> this.infoIndexChange.accept("setNextIndex " + message));
    }

    @Override
    public void updateNextIndex(long newNextIndex) {
        this.nextIndex.updateToMax(newNextIndex, message -> this.infoIndexChange.accept("decreaseNextIndex " + message));
    }

    @Override
    public void setSnapshotIndex(long newSnapshotIndex) {
        this.snapshotIndex.setUnconditionally(newSnapshotIndex, this.infoIndexChange);
        this.matchIndex.setUnconditionally(newSnapshotIndex, this.infoIndexChange);
        this.nextIndex.setUnconditionally(newSnapshotIndex + 1L, this.infoIndexChange);
    }

    @Override
    public void setAttemptedToInstallSnapshot() {
        LOG.info("Follower {} acknowledged installing snapshot", (Object)this.name);
        this.ackInstallSnapshotAttempt = true;
    }

    @Override
    public boolean hasAttemptedToInstallSnapshot() {
        return this.ackInstallSnapshotAttempt;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + "(c" + this.getCommitIndex() + ",m" + this.getMatchIndex() + ",n" + this.getNextIndex() + ", caughtUp=" + this.caughtUp + ", lastRpcSendTime=" + this.lastRpcSendTime.get().elapsedTimeMs() + ", lastRpcResponseTime=" + this.lastRpcResponseTime.get().elapsedTimeMs() + ")";
    }

    void catchUp() {
        this.caughtUp = true;
    }

    boolean isCaughtUp() {
        return this.caughtUp;
    }

    @Override
    public RaftPeerId getId() {
        return this.peer.get().getId();
    }

    @Override
    public RaftPeer getPeer() {
        RaftPeer newPeer = this.getPeer.apply(this.getId());
        if (newPeer != null) {
            this.peer.set(newPeer);
            return newPeer;
        }
        return this.peer.get();
    }

    @Override
    public void updateLastRpcResponseTime() {
        this.lastRpcResponseTime.set(Timestamp.currentTime());
    }

    @Override
    public Timestamp getLastRpcResponseTime() {
        return this.lastRpcResponseTime.get();
    }

    @Override
    public Timestamp getLastRpcSendTime() {
        return this.lastRpcSendTime.get();
    }

    @Override
    public void updateLastRpcSendTime(boolean isHeartbeat) {
        Timestamp currentTime = Timestamp.currentTime();
        this.lastRpcSendTime.set(currentTime);
        if (isHeartbeat) {
            this.lastHeartbeatSendTime.set(currentTime);
        }
    }

    @Override
    public Timestamp getLastRpcTime() {
        return Timestamp.latest(this.lastRpcResponseTime.get(), this.lastRpcSendTime.get());
    }

    @Override
    public Timestamp getLastHeartbeatSendTime() {
        return this.lastHeartbeatSendTime.get();
    }
}

