/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.protocol.exceptions.TimeoutIOException;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.TransferLeadership;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SnapshotManagementRequestHandler {
    public static final Logger LOG = LoggerFactory.getLogger(TransferLeadership.class);
    private final RaftServerImpl server;
    private final TimeoutExecutor scheduler = TimeoutExecutor.getInstance();
    private final PendingRequestReference pending = new PendingRequestReference();

    SnapshotManagementRequestHandler(RaftServerImpl server) {
        this.server = server;
    }

    CompletableFuture<RaftClientReply> takingSnapshotAsync(SnapshotManagementRequest request) {
        MemoizedSupplier<PendingRequest> supplier = JavaUtils.memoize(() -> new PendingRequest(request));
        PendingRequest previous = this.pending.getAndUpdate(supplier);
        if (previous != null) {
            return previous.getReplyFuture();
        }
        this.server.getState().notifyStateMachineUpdater();
        this.scheduler.onTimeout(TimeDuration.valueOf(request.getTimeoutMs(), TimeUnit.MILLISECONDS), this::timeout, LOG, () -> "Timeout check failed for snapshot request: " + request);
        return supplier.get().getReplyFuture();
    }

    boolean shouldTriggerTakingSnapshot() {
        return this.pending.get().map(PendingRequest::shouldTriggerTakingSnapshot).orElse(false);
    }

    void completeTakingSnapshot(long index) {
        this.pending.getAndSetNull().ifPresent(p -> p.complete(index));
    }

    void timeout() {
        this.pending.getAndSetNull().ifPresent(PendingRequest::timeout);
    }

    static class PendingRequestReference {
        private final AtomicReference<PendingRequest> ref = new AtomicReference();

        PendingRequestReference() {
        }

        Optional<PendingRequest> get() {
            return Optional.ofNullable(this.ref.get());
        }

        Optional<PendingRequest> getAndSetNull() {
            return Optional.ofNullable(this.ref.getAndSet(null));
        }

        PendingRequest getAndUpdate(Supplier<PendingRequest> supplier) {
            return this.ref.getAndUpdate(p -> p != null ? p : (PendingRequest)supplier.get());
        }
    }

    class PendingRequest {
        private final SnapshotManagementRequest request;
        private final CompletableFuture<RaftClientReply> replyFuture = new CompletableFuture();
        private final AtomicBoolean triggerTakingSnapshot = new AtomicBoolean(true);

        PendingRequest(SnapshotManagementRequest request) {
            LOG.info("new PendingRequest " + request);
            this.request = request;
        }

        CompletableFuture<RaftClientReply> getReplyFuture() {
            return this.replyFuture;
        }

        boolean shouldTriggerTakingSnapshot() {
            return this.triggerTakingSnapshot.getAndSet(false);
        }

        void complete(long index) {
            LOG.info("{}: Successfully take snapshot at index {} for request {}", SnapshotManagementRequestHandler.this.server.getMemberId(), index, this.request);
            this.replyFuture.complete(SnapshotManagementRequestHandler.this.server.newSuccessReply(this.request, index));
        }

        void timeout() {
            this.replyFuture.completeExceptionally(new TimeoutIOException(SnapshotManagementRequestHandler.this.server.getMemberId() + ": Failed to take a snapshot within timeout " + this.request.getTimeoutMs() + "ms"));
        }

        public String toString() {
            return this.request.toString();
        }
    }
}

