/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import com.codahale.metrics.Timer;
import java.util.Optional;
import java.util.function.LongSupplier;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.RatisMetrics;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.util.Timestamp;

public final class LeaderElectionMetrics
extends RatisMetrics {
    public static final String RATIS_LEADER_ELECTION_METRICS = "leader_election";
    public static final String RATIS_LEADER_ELECTION_METRICS_DESC = "Metrics for Ratis Leader Election.";
    public static final String LEADER_ELECTION_COUNT_METRIC = "electionCount";
    public static final String LEADER_ELECTION_TIMEOUT_COUNT_METRIC = "timeoutCount";
    public static final String LEADER_ELECTION_TIME_TAKEN = "electionTime";
    public static final String LAST_LEADER_ELAPSED_TIME = "lastLeaderElapsedTime";
    public static final String TRANSFER_LEADERSHIP_COUNT_METRIC = "transferLeadershipCount";
    public static final String LAST_LEADER_ELECTION_ELAPSED_TIME = "lastLeaderElectionElapsedTime";
    private volatile Timestamp lastElectionTime;

    private LeaderElectionMetrics(RaftGroupMemberId serverId, LongSupplier getLastLeaderElapsedTimeMs) {
        this.registry = LeaderElectionMetrics.getMetricRegistryForLeaderElection(serverId);
        this.registry.gauge(LAST_LEADER_ELAPSED_TIME, () -> getLastLeaderElapsedTimeMs::getAsLong);
        this.registry.gauge(LAST_LEADER_ELECTION_ELAPSED_TIME, () -> () -> Optional.ofNullable(this.lastElectionTime).map(Timestamp::elapsedTimeMs).orElse(-1L));
    }

    public static RatisMetricRegistry getMetricRegistryForLeaderElection(RaftGroupMemberId serverId) {
        return LeaderElectionMetrics.create(new MetricRegistryInfo(serverId.toString(), "ratis", RATIS_LEADER_ELECTION_METRICS, RATIS_LEADER_ELECTION_METRICS_DESC));
    }

    public static LeaderElectionMetrics getLeaderElectionMetrics(RaftGroupMemberId serverId, LongSupplier getLastLeaderElapsedTimeMs) {
        return new LeaderElectionMetrics(serverId, getLastLeaderElapsedTimeMs);
    }

    public void onNewLeaderElectionCompletion() {
        this.registry.counter(LEADER_ELECTION_COUNT_METRIC).inc();
        this.lastElectionTime = Timestamp.currentTime();
    }

    public Timer getLeaderElectionTimer() {
        return this.registry.timer(LEADER_ELECTION_TIME_TAKEN);
    }

    public void onLeaderElectionTimeout() {
        this.registry.counter(LEADER_ELECTION_TIMEOUT_COUNT_METRIC).inc();
    }

    public void onTransferLeadership() {
        this.registry.counter(TRANSFER_LEADERSHIP_COUNT_METRIC).inc();
    }
}

