/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import com.codahale.metrics.Timer;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.RatisMetrics;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.server.metrics.RaftLogMetrics;
import org.apache.ratis.server.raftlog.LogEntryHeader;

public class RaftLogMetricsBase
extends RatisMetrics
implements RaftLogMetrics {
    public static final String RATIS_LOG_WORKER_METRICS_DESC = "Metrics for Log Worker";
    public static final String RATIS_LOG_WORKER_METRICS = "log_worker";
    public static final String METADATA_LOG_ENTRY_COUNT = "metadataLogEntryCount";
    public static final String CONFIG_LOG_ENTRY_COUNT = "configLogEntryCount";
    public static final String STATE_MACHINE_LOG_ENTRY_COUNT = "stateMachineLogEntryCount";
    public static final String RAFT_LOG_READ_ENTRY_LATENCY = "readEntryLatency";
    public static final String RAFT_LOG_LOAD_SEGMENT_LATENCY = "segmentLoadLatency";

    public RaftLogMetricsBase(RaftGroupMemberId serverId) {
        this.registry = RaftLogMetricsBase.getLogWorkerMetricRegistry(serverId);
    }

    public static RatisMetricRegistry getLogWorkerMetricRegistry(RaftGroupMemberId serverId) {
        return RaftLogMetricsBase.create(new MetricRegistryInfo(serverId.toString(), "ratis", RATIS_LOG_WORKER_METRICS, RATIS_LOG_WORKER_METRICS_DESC));
    }

    private Timer getTimer(String timerName) {
        return this.registry.timer(timerName);
    }

    @Override
    public void onLogEntryCommitted(LogEntryHeader header) {
        switch (header.getLogEntryBodyCase()) {
            case CONFIGURATIONENTRY: {
                this.registry.counter(CONFIG_LOG_ENTRY_COUNT).inc();
                return;
            }
            case METADATAENTRY: {
                this.registry.counter(METADATA_LOG_ENTRY_COUNT).inc();
                return;
            }
            case STATEMACHINELOGENTRY: {
                this.registry.counter(STATE_MACHINE_LOG_ENTRY_COUNT).inc();
                return;
            }
        }
    }

    public Timer getRaftLogReadEntryTimer() {
        return this.getTimer(RAFT_LOG_READ_ENTRY_LATENCY);
    }

    public Timer getRaftLogLoadSegmentTimer() {
        return this.getTimer(RAFT_LOG_LOAD_SEGMENT_LATENCY);
    }
}

