/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.server.raftlog.RaftLogIndex;
import org.apache.ratis.server.raftlog.RaftLogSequentialOps;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.OpenCloseState;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;

public abstract class RaftLogBase
implements RaftLog {
    private final Consumer<Object> infoIndexChange = s2 -> LOG.info("{}: {}", (Object)this.getName(), s2);
    private final Consumer<Object> traceIndexChange = s2 -> LOG.trace("{}: {}", (Object)this.getName(), s2);
    public static final long LEAST_VALID_LOG_INDEX = 0L;
    public static final long INVALID_LOG_INDEX = -1L;
    private final String name;
    private final RaftLogIndex commitIndex;
    private final RaftLogIndex snapshotIndex;
    private final RaftLogIndex purgeIndex;
    private final int purgeGap;
    private final RaftGroupMemberId memberId;
    private final int maxBufferSize;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final RaftLogSequentialOps.Runner runner = new RaftLogSequentialOps.Runner(this::getName);
    private final OpenCloseState state;
    private final LongSupplier getSnapshotIndexFromStateMachine;
    private final TimeDuration stateMachineDataReadTimeout;
    private final long purgePreservation;
    private volatile RaftProtos.LogEntryProto lastMetadataEntry = null;

    protected RaftLogBase(RaftGroupMemberId memberId, LongSupplier getSnapshotIndexFromStateMachine, RaftProperties properties) {
        this.name = memberId + "-" + JavaUtils.getClassSimpleName(this.getClass());
        this.memberId = memberId;
        long index = getSnapshotIndexFromStateMachine.getAsLong();
        this.commitIndex = new RaftLogIndex("commitIndex", index);
        this.snapshotIndex = new RaftLogIndex("snapshotIndex", index);
        this.purgeIndex = new RaftLogIndex("purgeIndex", -1L);
        this.purgeGap = RaftServerConfigKeys.Log.purgeGap(properties);
        this.maxBufferSize = RaftServerConfigKeys.Log.Appender.bufferByteLimit(properties).getSizeInt();
        this.state = new OpenCloseState(this.getName());
        this.getSnapshotIndexFromStateMachine = getSnapshotIndexFromStateMachine;
        this.stateMachineDataReadTimeout = RaftServerConfigKeys.Log.StateMachineData.readTimeout(properties);
        this.purgePreservation = RaftServerConfigKeys.Log.purgePreservationLogNum(properties);
    }

    @Override
    public long getLastCommittedIndex() {
        return this.commitIndex.get();
    }

    @Override
    public long getSnapshotIndex() {
        return this.snapshotIndex.get();
    }

    public void checkLogState() {
        this.state.assertOpen();
    }

    public boolean isOpened() {
        return this.state.isOpened();
    }

    @Override
    public boolean updateCommitIndex(long majorityIndex, long currentTerm, boolean isLeader) {
        try (AutoCloseableLock writeLock = this.writeLock();){
            long oldCommittedIndex = this.getLastCommittedIndex();
            long newCommitIndex = Math.min(majorityIndex, this.getFlushIndex());
            if (oldCommittedIndex < newCommitIndex) {
                if (!isLeader) {
                    this.commitIndex.updateIncreasingly(newCommitIndex, this.traceIndexChange);
                    boolean bl = true;
                    return bl;
                }
                TermIndex entry = this.getTermIndex(newCommitIndex);
                if (entry != null && entry.getTerm() == currentTerm) {
                    this.commitIndex.updateIncreasingly(newCommitIndex, this.traceIndexChange);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    protected void updateSnapshotIndexFromStateMachine() {
        this.updateSnapshotIndex(this.getSnapshotIndexFromStateMachine.getAsLong());
    }

    @Override
    public void updateSnapshotIndex(long newSnapshotIndex) {
        try (AutoCloseableLock writeLock = this.writeLock();){
            long oldCommitIndex;
            long oldSnapshotIndex = this.getSnapshotIndex();
            if (oldSnapshotIndex < newSnapshotIndex) {
                this.snapshotIndex.updateIncreasingly(newSnapshotIndex, this.infoIndexChange);
            }
            if ((oldCommitIndex = this.getLastCommittedIndex()) < newSnapshotIndex) {
                this.commitIndex.updateIncreasingly(newSnapshotIndex, this.traceIndexChange);
            }
        }
    }

    @Override
    public final long append(long term, TransactionContext transaction) throws StateMachineException {
        return this.runner.runSequentially(() -> this.appendImpl(term, transaction));
    }

    private long appendImpl(long term, TransactionContext operation) throws StateMachineException {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            long nextIndex = this.getNextIndex();
            try {
                operation = operation.preAppendTransaction();
            }
            catch (StateMachineException e) {
                throw e;
            }
            catch (IOException e) {
                throw new StateMachineException(this.memberId, (Throwable)e);
            }
            RaftProtos.LogEntryProto e = operation.initLogEntry(term, nextIndex);
            int entrySize = e.getSerializedSize();
            if (entrySize > this.maxBufferSize) {
                throw new StateMachineException(this.memberId, (Throwable)new RaftLogIOException("Log entry size " + entrySize + " exceeds the max buffer limit of " + this.maxBufferSize));
            }
            this.appendEntry(e);
            long l = nextIndex;
            return l;
        }
    }

    @Override
    public final long appendMetadata(long term, long newCommitIndex) {
        return this.runner.runSequentially(() -> this.appendMetadataImpl(term, newCommitIndex));
    }

    private long appendMetadataImpl(long term, long newCommitIndex) {
        RaftProtos.LogEntryProto entry;
        long nextIndex;
        this.checkLogState();
        if (!this.shouldAppendMetadata(newCommitIndex)) {
            return -1L;
        }
        try (AutoCloseableLock writeLock = this.writeLock();){
            nextIndex = this.getNextIndex();
            entry = LogProtoUtils.toLogEntryProto(newCommitIndex, term, nextIndex);
            this.appendEntry(entry);
        }
        this.lastMetadataEntry = entry;
        return nextIndex;
    }

    private boolean shouldAppendMetadata(long newCommitIndex) {
        if (newCommitIndex <= 0L) {
            return false;
        }
        if (Optional.ofNullable(this.lastMetadataEntry).filter(e -> e.getIndex() == newCommitIndex || e.getMetadataEntry().getCommitIndex() >= newCommitIndex).isPresent()) {
            return false;
        }
        try {
            if (this.get(newCommitIndex).hasMetadataEntry()) {
                return false;
            }
        }
        catch (RaftLogIOException e2) {
            LOG.error("Failed to get log entry for index " + newCommitIndex, e2);
        }
        return true;
    }

    @Override
    public final long append(long term, RaftConfiguration configuration) {
        return this.runner.runSequentially(() -> this.appendImpl(term, configuration));
    }

    private long appendImpl(long term, RaftConfiguration newConf) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            long nextIndex = this.getNextIndex();
            this.appendEntry(LogProtoUtils.toLogEntryProto(newConf, (Long)term, nextIndex));
            long l = nextIndex;
            return l;
        }
    }

    @Override
    public final void open(long lastIndexInSnapshot, Consumer<RaftProtos.LogEntryProto> consumer) throws IOException {
        this.openImpl(lastIndexInSnapshot, e -> {
            if (e.hasMetadataEntry()) {
                this.lastMetadataEntry = e;
            } else if (consumer != null) {
                consumer.accept((RaftProtos.LogEntryProto)e);
            }
        });
        Optional.ofNullable(this.lastMetadataEntry).ifPresent(e -> this.commitIndex.updateToMax(e.getMetadataEntry().getCommitIndex(), this.infoIndexChange));
        this.state.open();
        long startIndex = this.getStartIndex();
        if (startIndex > 0L) {
            this.purgeIndex.updateIncreasingly(startIndex - 1L, this.infoIndexChange);
        }
    }

    protected void openImpl(long lastIndexInSnapshot, Consumer<RaftProtos.LogEntryProto> consumer) throws IOException {
    }

    protected void validateLogEntry(RaftProtos.LogEntryProto entry) {
        if (entry.hasMetadataEntry()) {
            return;
        }
        long latestSnapshotIndex = this.getSnapshotIndex();
        TermIndex lastTermIndex = this.getLastEntryTermIndex();
        if (lastTermIndex != null) {
            long lastIndex = lastTermIndex.getIndex() > latestSnapshotIndex ? lastTermIndex.getIndex() : latestSnapshotIndex;
            Preconditions.assertTrue(entry.getTerm() >= lastTermIndex.getTerm(), "Entry term less than RaftLog's last term: %d, entry: %s", lastTermIndex.getTerm(), entry);
            Preconditions.assertTrue(entry.getIndex() == lastIndex + 1L, "Difference between entry index and RaftLog's last index %d (or snapshot index %d) is greater than 1, entry: %s", lastTermIndex.getIndex(), latestSnapshotIndex, entry);
        } else {
            Preconditions.assertTrue(entry.getIndex() == latestSnapshotIndex + 1L, "Difference between entry index and RaftLog's latest snapshot index %d is greater than 1 and in between log entries are not present, entry: %s", latestSnapshotIndex, entry);
        }
    }

    @Override
    public final CompletableFuture<Long> truncate(long index) {
        return this.runner.runSequentially(() -> this.truncateImpl(index));
    }

    protected abstract CompletableFuture<Long> truncateImpl(long var1);

    @Override
    public final CompletableFuture<Long> purge(long suggestedIndex) {
        long lastPurge;
        if (this.purgePreservation > 0L) {
            long currentIndex = this.getNextIndex() - 1L;
            suggestedIndex = Math.min(suggestedIndex, currentIndex - this.purgePreservation);
        }
        if (suggestedIndex - (lastPurge = this.purgeIndex.get()) < (long)this.purgeGap) {
            return CompletableFuture.completedFuture(lastPurge);
        }
        LOG.info("{}: purge {}", (Object)this.getName(), (Object)suggestedIndex);
        long finalSuggestedIndex = suggestedIndex;
        return this.purgeImpl(suggestedIndex).whenComplete((purged, e) -> {
            if (purged != null) {
                this.purgeIndex.updateToMax((long)purged, this.infoIndexChange);
            }
            if (e != null) {
                LOG.warn(this.getName() + ": Failed to purge " + finalSuggestedIndex, (Throwable)e);
            }
        });
    }

    protected abstract CompletableFuture<Long> purgeImpl(long var1);

    @Override
    public final CompletableFuture<Long> appendEntry(RaftProtos.LogEntryProto entry) {
        return this.runner.runSequentially(() -> this.appendEntryImpl(entry));
    }

    protected abstract CompletableFuture<Long> appendEntryImpl(RaftProtos.LogEntryProto var1);

    @Override
    public final List<CompletableFuture<Long>> append(List<RaftProtos.LogEntryProto> entries) {
        return this.runner.runSequentially(() -> this.appendImpl(entries));
    }

    protected abstract List<CompletableFuture<Long>> appendImpl(List<RaftProtos.LogEntryProto> var1);

    public String toString() {
        return this.getName() + ":" + this.state + ":c" + this.getLastCommittedIndex();
    }

    public AutoCloseableLock readLock() {
        return AutoCloseableLock.acquire(this.lock.readLock());
    }

    public AutoCloseableLock writeLock() {
        return AutoCloseableLock.acquire(this.lock.writeLock());
    }

    public boolean hasWriteLock() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    public boolean hasReadLock() {
        return this.lock.getReadHoldCount() > 0 || this.hasWriteLock();
    }

    @Override
    public void close() throws IOException {
        this.state.close();
    }

    public String getName() {
        return this.name;
    }

    protected RaftLog.EntryWithData newEntryWithData(RaftProtos.LogEntryProto logEntry, CompletableFuture<ByteString> future) {
        return new EntryWithDataImpl(logEntry, future);
    }

    public String toLogEntryString(RaftProtos.LogEntryProto logEntry) {
        return LogProtoUtils.toLogEntryString(logEntry);
    }

    class EntryWithDataImpl
    implements RaftLog.EntryWithData {
        private final RaftProtos.LogEntryProto logEntry;
        private final CompletableFuture<ByteString> future;

        EntryWithDataImpl(RaftProtos.LogEntryProto logEntry, CompletableFuture<ByteString> future) {
            this.logEntry = logEntry;
            this.future = future == null ? null : future.thenApply(this::checkStateMachineData);
        }

        private ByteString checkStateMachineData(ByteString data) {
            if (data == null) {
                throw new IllegalStateException("State machine data is null for log entry " + this.logEntry);
            }
            return data;
        }

        @Override
        public int getSerializedSize() {
            return LogProtoUtils.getSerializedSize(this.logEntry);
        }

        @Override
        public RaftProtos.LogEntryProto getEntry(TimeDuration timeout) throws RaftLogIOException, TimeoutException {
            RaftProtos.LogEntryProto entryProto;
            if (this.future == null) {
                return this.logEntry;
            }
            try {
                entryProto = (RaftProtos.LogEntryProto)((CompletableFuture)this.future.thenApply(data -> LogProtoUtils.addStateMachineData(data, this.logEntry))).get(timeout.getDuration(), timeout.getUnit());
            }
            catch (TimeoutException t2) {
                if (timeout.compareTo(RaftLogBase.this.stateMachineDataReadTimeout) > 0) {
                    RaftLogBase.this.getRaftLogMetrics().onStateMachineDataReadTimeout();
                }
                throw t2;
            }
            catch (Exception e) {
                String err = RaftLogBase.this.getName() + ": Failed readStateMachineData for " + RaftLogBase.this.toLogEntryString(this.logEntry);
                RaftLog.LOG.error(err, e);
                throw new RaftLogIOException(err, JavaUtils.unwrapCompletionException(e));
            }
            if (LogProtoUtils.isStateMachineDataEmpty(entryProto)) {
                String err = RaftLogBase.this.getName() + ": State machine data not set for " + RaftLogBase.this.toLogEntryString(this.logEntry);
                RaftLog.LOG.error(err);
                throw new RaftLogIOException(err);
            }
            return entryProto;
        }

        public String toString() {
            return RaftLogBase.this.toLogEntryString(this.logEntry);
        }
    }
}

