/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.zip.Checksum;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.raftlog.segmented.BufferedWriteChannel;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogFormat;
import org.apache.ratis.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.PureJavaCrc32C;
import org.apache.ratis.util.function.CheckedConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentedRaftLogOutputStream
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentedRaftLogOutputStream.class);
    private static final ByteBuffer FILL = ByteBuffer.allocateDirect(0x100000);
    private static final int BUFFER_SIZE = 0x100000;
    private final File file;
    private final BufferedWriteChannel out;
    private final Checksum checksum;
    private final Supplier<byte[]> sharedBuffer;
    private final long segmentMaxSize;
    private final long preallocatedSize;

    public SegmentedRaftLogOutputStream(File file, boolean append, long segmentMaxSize, long preallocatedSize, ByteBuffer byteBuffer) throws IOException {
        this(file, append, segmentMaxSize, preallocatedSize, byteBuffer, null);
    }

    SegmentedRaftLogOutputStream(File file, boolean append, long segmentMaxSize, long preallocatedSize, ByteBuffer byteBuffer, Supplier<byte[]> sharedBuffer) throws IOException {
        this.file = file;
        this.checksum = new PureJavaCrc32C();
        this.segmentMaxSize = segmentMaxSize;
        this.preallocatedSize = preallocatedSize;
        this.sharedBuffer = sharedBuffer;
        this.out = BufferedWriteChannel.open(file, append, byteBuffer);
        if (!append) {
            this.preallocateIfNecessary(SegmentedRaftLogFormat.getHeaderLength());
            SegmentedRaftLogFormat.applyHeaderTo(CheckedConsumer.asCheckedFunction(this.out::write));
            this.out.flush();
        }
    }

    public void write(RaftProtos.LogEntryProto entry) throws IOException {
        int serialized = entry.getSerializedSize();
        int proto = CodedOutputStream.computeUInt32SizeNoTag(serialized) + serialized;
        int total = proto + 4;
        byte[] buf = this.sharedBuffer != null ? this.sharedBuffer.get() : new byte[total];
        Preconditions.assertTrue(total <= buf.length, () -> "total = " + total + " > buf.length " + buf.length);
        this.preallocateIfNecessary(total);
        CodedOutputStream cout = CodedOutputStream.newInstance(buf);
        cout.writeUInt32NoTag(serialized);
        entry.writeTo(cout);
        this.checksum.reset();
        this.checksum.update(buf, 0, proto);
        ByteBuffer.wrap(buf, proto, 4).putInt((int)this.checksum.getValue());
        this.out.write(buf, total);
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(LOG, this.out);
            throw throwable;
        }
        IOUtils.cleanup(LOG, this.out);
    }

    public void flush() throws IOException {
        try {
            this.out.flush();
        }
        catch (IOException ioe) {
            String msg = "Failed to flush " + this;
            LOG.error(msg, ioe);
            throw new IOException(msg, ioe);
        }
    }

    CompletableFuture<Void> asyncFlush(ExecutorService executor) throws IOException {
        try {
            return this.out.asyncFlush(executor);
        }
        catch (IOException ioe) {
            String msg = "Failed to asyncFlush " + this;
            LOG.error(msg, ioe);
            throw new IOException(msg, ioe);
        }
    }

    private static long actualPreallocateSize(long outstandingData, long remainingSpace, long preallocate) {
        return outstandingData > remainingSpace ? outstandingData : (outstandingData > preallocate ? outstandingData : Math.min(preallocate, remainingSpace));
    }

    private long preallocate(FileChannel fc, long outstanding) throws IOException {
        long actual = SegmentedRaftLogOutputStream.actualPreallocateSize(outstanding, this.segmentMaxSize - fc.size(), this.preallocatedSize);
        Preconditions.assertTrue(actual >= outstanding);
        long allocated = IOUtils.preallocate(fc, actual, FILL);
        LOG.debug("Pre-allocated {} bytes for {}", (Object)allocated, (Object)this);
        return allocated;
    }

    private void preallocateIfNecessary(int size) throws IOException {
        this.out.preallocateIfNecessary(size, this::preallocate);
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + "(" + this.file + ")";
    }

    static {
        for (int i = 0; i < FILL.capacity(); ++i) {
            FILL.put(SegmentedRaftLogFormat.getTerminator());
        }
        FILL.flip();
    }
}

