/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.server.storage.RaftStorageMetadataFile;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.ReflectionUtils;
import org.apache.ratis.util.SizeInBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RaftStorage
extends Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(RaftStorage.class);

    public void initialize() throws IOException;

    public RaftStorageDirectory getStorageDir();

    public RaftStorageMetadataFile getMetadataFile();

    public RaftServerConfigKeys.Log.CorruptionPolicy getLogCorruptionPolicy();

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private static final Method NEW_RAFT_STORAGE_METHOD = Builder.initNewRaftStorageMethod();
        private File directory;
        private RaftServerConfigKeys.Log.CorruptionPolicy logCorruptionPolicy;
        private StartupOption option;
        private SizeInBytes storageFreeSpaceMin;

        private static Method initNewRaftStorageMethod() {
            String className = RaftStorage.class.getPackage().getName() + ".StorageImplUtils";
            Class[] argClasses = new Class[]{File.class, RaftServerConfigKeys.Log.CorruptionPolicy.class, StartupOption.class, Long.TYPE};
            try {
                Class<?> clazz = ReflectionUtils.getClassByName(className);
                return clazz.getMethod("newRaftStorage", argClasses);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to initNewRaftStorageMethod", e);
            }
        }

        private static RaftStorage newRaftStorage(File dir, RaftServerConfigKeys.Log.CorruptionPolicy logCorruptionPolicy, StartupOption option, SizeInBytes storageFreeSpaceMin) throws IOException {
            try {
                return (RaftStorage)NEW_RAFT_STORAGE_METHOD.invoke(null, new Object[]{dir, logCorruptionPolicy, option, storageFreeSpaceMin.getSize()});
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to build " + dir, e);
            }
            catch (InvocationTargetException e) {
                Throwable t2 = e.getTargetException();
                if (t2.getCause() instanceof IOException) {
                    throw IOUtils.asIOException(t2.getCause());
                }
                throw IOUtils.asIOException(e.getCause());
            }
        }

        public Builder setDirectory(File directory) {
            this.directory = directory;
            return this;
        }

        public Builder setLogCorruptionPolicy(RaftServerConfigKeys.Log.CorruptionPolicy logCorruptionPolicy) {
            this.logCorruptionPolicy = logCorruptionPolicy;
            return this;
        }

        public Builder setOption(StartupOption option) {
            this.option = option;
            return this;
        }

        public Builder setStorageFreeSpaceMin(SizeInBytes storageFreeSpaceMin) {
            this.storageFreeSpaceMin = storageFreeSpaceMin;
            return this;
        }

        public RaftStorage build() throws IOException {
            return Builder.newRaftStorage(this.directory, this.logCorruptionPolicy, this.option, this.storageFreeSpaceMin);
        }
    }

    public static enum StartupOption {
        FORMAT,
        RECOVER;

    }
}

