/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageImpl;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;

public final class StorageImplUtils {
    private StorageImplUtils() {
    }

    public static RaftStorageImpl newRaftStorage(File dir, RaftServerConfigKeys.Log.CorruptionPolicy logCorruptionPolicy, RaftStorage.StartupOption option, long storageFeeSpaceMin) throws IOException {
        RaftStorageImpl raftStorage;
        RaftStorage.LOG.debug("newRaftStorage: {}, {}, {}, {}", new Object[]{dir, logCorruptionPolicy, option, storageFeeSpaceMin});
        TimeDuration sleepTime = TimeDuration.valueOf(500L, TimeUnit.MILLISECONDS);
        try {
            raftStorage = JavaUtils.attemptRepeatedly(() -> new RaftStorageImpl(dir, logCorruptionPolicy, option, storageFeeSpaceMin), 5, sleepTime, "new RaftStorageImpl", RaftStorage.LOG);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException("Interrupted when creating RaftStorage " + dir, e);
        }
        return raftStorage;
    }
}

