/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.com.codahale.metrics.ganglia;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.ratis.thirdparty.com.codahale.metrics.Counter;
import org.apache.ratis.thirdparty.com.codahale.metrics.Gauge;
import org.apache.ratis.thirdparty.com.codahale.metrics.Histogram;
import org.apache.ratis.thirdparty.com.codahale.metrics.Meter;
import org.apache.ratis.thirdparty.com.codahale.metrics.Metered;
import org.apache.ratis.thirdparty.com.codahale.metrics.Metric;
import org.apache.ratis.thirdparty.com.codahale.metrics.MetricAttribute;
import org.apache.ratis.thirdparty.com.codahale.metrics.MetricFilter;
import org.apache.ratis.thirdparty.com.codahale.metrics.MetricRegistry;
import org.apache.ratis.thirdparty.com.codahale.metrics.ScheduledReporter;
import org.apache.ratis.thirdparty.com.codahale.metrics.Snapshot;
import org.apache.ratis.thirdparty.com.codahale.metrics.Timer;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.gmetric.GMetric;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.gmetric.GMetricSlope;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.gmetric.GMetricType;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.gmetric.GangliaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GangliaReporter
extends ScheduledReporter {
    private static final Pattern SLASHES = Pattern.compile("\\\\");
    private static final Logger LOGGER = LoggerFactory.getLogger(GangliaReporter.class);
    private final GMetric gmetric;
    private final GMetric[] gmetrics;
    private final String prefix;
    private final int tMax;
    private final int dMax;
    private static final double MIN_VAL = 1.0E-300;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private GangliaReporter(MetricRegistry registry, GMetric gmetric, GMetric[] gmetrics, String prefix, int tMax, int dMax, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, ScheduledExecutorService executor, boolean shutdownExecutorOnStop, Set<MetricAttribute> disabledMetricAttributes) {
        super(registry, "ganglia-reporter", filter, rateUnit, durationUnit, executor, shutdownExecutorOnStop, disabledMetricAttributes);
        this.gmetric = gmetric;
        this.gmetrics = gmetrics;
        this.prefix = prefix;
        this.tMax = tMax;
        this.dMax = dMax;
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.reportGauge(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Metric> entry : counters.entrySet()) {
            this.reportCounter(entry.getKey(), (Counter)entry.getValue());
        }
        for (Map.Entry<String, Metric> entry : histograms.entrySet()) {
            this.reportHistogram(entry.getKey(), (Histogram)entry.getValue());
        }
        for (Map.Entry<String, Metric> entry : meters.entrySet()) {
            this.reportMeter(entry.getKey(), (Meter)entry.getValue());
        }
        for (Map.Entry<String, Metric> entry : timers.entrySet()) {
            this.reportTimer(entry.getKey(), (Timer)entry.getValue());
        }
    }

    private void reportTimer(String name, Timer timer) {
        String sanitizedName = this.escapeSlashes(name);
        String group = this.group(name);
        try {
            Snapshot snapshot = timer.getSnapshot();
            this.announceIfEnabled(MetricAttribute.MAX, sanitizedName, group, this.convertDuration(snapshot.getMax()), this.getDurationUnit());
            this.announceIfEnabled(MetricAttribute.MEAN, sanitizedName, group, this.convertDuration(snapshot.getMean()), this.getDurationUnit());
            this.announceIfEnabled(MetricAttribute.MIN, sanitizedName, group, this.convertDuration(snapshot.getMin()), this.getDurationUnit());
            this.announceIfEnabled(MetricAttribute.STDDEV, sanitizedName, group, this.convertDuration(snapshot.getStdDev()), this.getDurationUnit());
            this.announceIfEnabled(MetricAttribute.P50, sanitizedName, group, this.convertDuration(snapshot.getMedian()), this.getDurationUnit());
            this.announceIfEnabled(MetricAttribute.P75, sanitizedName, group, this.convertDuration(snapshot.get75thPercentile()), this.getDurationUnit());
            this.announceIfEnabled(MetricAttribute.P95, sanitizedName, group, this.convertDuration(snapshot.get95thPercentile()), this.getDurationUnit());
            this.announceIfEnabled(MetricAttribute.P98, sanitizedName, group, this.convertDuration(snapshot.get98thPercentile()), this.getDurationUnit());
            this.announceIfEnabled(MetricAttribute.P99, sanitizedName, group, this.convertDuration(snapshot.get99thPercentile()), this.getDurationUnit());
            this.announceIfEnabled(MetricAttribute.P999, sanitizedName, group, this.convertDuration(snapshot.get999thPercentile()), this.getDurationUnit());
            this.reportMetered(sanitizedName, timer, group, "calls");
        }
        catch (GangliaException e) {
            LOGGER.warn("Unable to report timer {}", (Object)sanitizedName, (Object)e);
        }
    }

    private void reportMeter(String name, Meter meter) {
        String sanitizedName = this.escapeSlashes(name);
        String group = this.group(name);
        try {
            this.reportMetered(sanitizedName, meter, group, "events");
        }
        catch (GangliaException e) {
            LOGGER.warn("Unable to report meter {}", (Object)name, (Object)e);
        }
    }

    private void reportMetered(String name, Metered meter, String group, String eventName) throws GangliaException {
        String unit = eventName + '/' + this.getRateUnit();
        this.announceIfEnabled(MetricAttribute.COUNT, name, group, meter.getCount(), eventName);
        this.announceIfEnabled(MetricAttribute.M1_RATE, name, group, this.convertRate(meter.getOneMinuteRate()), unit);
        this.announceIfEnabled(MetricAttribute.M5_RATE, name, group, this.convertRate(meter.getFiveMinuteRate()), unit);
        this.announceIfEnabled(MetricAttribute.M15_RATE, name, group, this.convertRate(meter.getFifteenMinuteRate()), unit);
        this.announceIfEnabled(MetricAttribute.MEAN_RATE, name, group, this.convertRate(meter.getMeanRate()), unit);
    }

    private void reportHistogram(String name, Histogram histogram) {
        String sanitizedName = this.escapeSlashes(name);
        String group = this.group(name);
        try {
            Snapshot snapshot = histogram.getSnapshot();
            this.announceIfEnabled(MetricAttribute.COUNT, sanitizedName, group, histogram.getCount(), "");
            this.announceIfEnabled(MetricAttribute.MAX, sanitizedName, group, snapshot.getMax(), "");
            this.announceIfEnabled(MetricAttribute.MEAN, sanitizedName, group, snapshot.getMean(), "");
            this.announceIfEnabled(MetricAttribute.MIN, sanitizedName, group, snapshot.getMin(), "");
            this.announceIfEnabled(MetricAttribute.STDDEV, sanitizedName, group, snapshot.getStdDev(), "");
            this.announceIfEnabled(MetricAttribute.P50, sanitizedName, group, snapshot.getMedian(), "");
            this.announceIfEnabled(MetricAttribute.P75, sanitizedName, group, snapshot.get75thPercentile(), "");
            this.announceIfEnabled(MetricAttribute.P95, sanitizedName, group, snapshot.get95thPercentile(), "");
            this.announceIfEnabled(MetricAttribute.P98, sanitizedName, group, snapshot.get98thPercentile(), "");
            this.announceIfEnabled(MetricAttribute.P99, sanitizedName, group, snapshot.get99thPercentile(), "");
            this.announceIfEnabled(MetricAttribute.P999, sanitizedName, group, snapshot.get999thPercentile(), "");
        }
        catch (GangliaException e) {
            LOGGER.warn("Unable to report histogram {}", (Object)sanitizedName, (Object)e);
        }
    }

    private void reportCounter(String name, Counter counter) {
        String sanitizedName = this.escapeSlashes(name);
        String group = this.group(name);
        try {
            this.announce(this.prefix(sanitizedName, MetricAttribute.COUNT.getCode()), group, Long.toString(counter.getCount()), GMetricType.DOUBLE, "");
        }
        catch (GangliaException e) {
            LOGGER.warn("Unable to report counter {}", (Object)name, (Object)e);
        }
    }

    private void reportGauge(String name, Gauge gauge) {
        String sanitizedName = this.escapeSlashes(name);
        String group = this.group(name);
        Object obj = gauge.getValue();
        String value = String.valueOf(obj);
        GMetricType type = this.detectType(obj);
        try {
            this.announce(MetricRegistry.name(this.prefix, sanitizedName), group, value, type, "");
        }
        catch (GangliaException e) {
            LOGGER.warn("Unable to report gauge {}", (Object)name, (Object)e);
        }
    }

    private void announceIfEnabled(MetricAttribute metricAttribute, String metricName, String group, double value, String units) throws GangliaException {
        if (this.getDisabledMetricAttributes().contains((Object)metricAttribute)) {
            return;
        }
        String string = Math.abs(value) < 1.0E-300 ? "0" : Double.toString(value);
        this.announce(this.prefix(metricName, metricAttribute.getCode()), group, string, GMetricType.DOUBLE, units);
    }

    private void announceIfEnabled(MetricAttribute metricAttribute, String metricName, String group, long value, String units) throws GangliaException {
        if (this.getDisabledMetricAttributes().contains((Object)metricAttribute)) {
            return;
        }
        this.announce(this.prefix(metricName, metricAttribute.getCode()), group, Long.toString(value), GMetricType.DOUBLE, units);
    }

    private void announce(String name, String group, String value, GMetricType type, String units) throws GangliaException {
        if (this.gmetric != null) {
            this.gmetric.announce(name, value, type, units, GMetricSlope.BOTH, this.tMax, this.dMax, group);
        } else {
            for (GMetric gmetric : this.gmetrics) {
                gmetric.announce(name, value, type, units, GMetricSlope.BOTH, this.tMax, this.dMax, group);
            }
        }
    }

    private GMetricType detectType(Object o) {
        if (o instanceof Float) {
            return GMetricType.FLOAT;
        }
        if (o instanceof Double) {
            return GMetricType.DOUBLE;
        }
        if (o instanceof Byte) {
            return GMetricType.INT8;
        }
        if (o instanceof Short) {
            return GMetricType.INT16;
        }
        if (o instanceof Integer) {
            return GMetricType.INT32;
        }
        if (o instanceof Long) {
            return GMetricType.DOUBLE;
        }
        return GMetricType.STRING;
    }

    private String group(String name) {
        int i = name.lastIndexOf(46);
        if (i < 0) {
            return "";
        }
        return name.substring(0, i);
    }

    private String prefix(String name, String n) {
        return MetricRegistry.name(this.prefix, name, n);
    }

    private String escapeSlashes(String name) {
        return SLASHES.matcher(name).replaceAll("_");
    }

    public static class Builder {
        private final MetricRegistry registry;
        private String prefix;
        private int tMax;
        private int dMax;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private ScheduledExecutorService executor;
        private boolean shutdownExecutorOnStop;
        private Set<MetricAttribute> disabledMetricAttributes = Collections.emptySet();

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.tMax = 60;
            this.dMax = 0;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.executor = null;
            this.shutdownExecutorOnStop = true;
        }

        public Builder shutdownExecutorOnStop(boolean shutdownExecutorOnStop) {
            this.shutdownExecutorOnStop = shutdownExecutorOnStop;
            return this;
        }

        public Builder scheduleOn(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder withTMax(int tMax) {
            this.tMax = tMax;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder withDMax(int dMax) {
            this.dMax = dMax;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder disabledMetricAttributes(Set<MetricAttribute> disabledMetricAttributes) {
            this.disabledMetricAttributes = disabledMetricAttributes;
            return this;
        }

        public GangliaReporter build(GMetric gmetric) {
            return new GangliaReporter(this.registry, gmetric, null, this.prefix, this.tMax, this.dMax, this.rateUnit, this.durationUnit, this.filter, this.executor, this.shutdownExecutorOnStop, this.disabledMetricAttributes);
        }

        public GangliaReporter build(GMetric ... gmetrics) {
            return new GangliaReporter(this.registry, null, gmetrics, this.prefix, this.tMax, this.dMax, this.rateUnit, this.durationUnit, this.filter, this.executor, this.shutdownExecutorOnStop, this.disabledMetricAttributes);
        }
    }
}

