/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common;

import java.util.List;
import lombok.Generated;
import org.dromara.hodor.common.utils.StringUtils;

public class Host {
    private String endpoint;
    private String ip;
    private int port;

    public static Host of(String endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint must not be null.");
        }
        List<String> hostSplit = StringUtils.splitToList(endpoint, ":");
        if (hostSplit.size() == 1) {
            return Host.builder().endpoint(endpoint).ip(hostSplit.get(0)).port(80).build();
        }
        if (hostSplit.size() != 2) {
            throw new IllegalArgumentException(" endpoint format is illegal, " + endpoint);
        }
        return Host.builder().endpoint(endpoint).ip(hostSplit.get(0)).port(Integer.parseInt(hostSplit.get(1))).build();
    }

    public static HostBuilder builder() {
        return new HostBuilder();
    }

    public String toString() {
        return "Host {ip=" + this.ip + ", port=" + this.port + "}";
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public Host() {
    }

    @Generated
    public Host(String endpoint, String ip, int port) {
        this.endpoint = endpoint;
        this.ip = ip;
        this.port = port;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Host)) {
            return false;
        }
        Host other = (Host)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        return !(this$ip == null ? other$ip != null : !this$ip.equals(other$ip));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Host;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        return result;
    }

    public static class HostBuilder {
        private String endpoint;
        private String ip;
        private int port;

        HostBuilder() {
        }

        public HostBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public HostBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public HostBuilder port(int port) {
            this.port = port;
            return this;
        }

        public Host build() {
            if (this.endpoint == null) {
                this.endpoint = this.ip + ":" + this.port;
            }
            return new Host(this.endpoint, this.ip, this.port);
        }
    }
}

