/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.concurrent;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorServiceUtils.class);
    private static final TimeUnit MILLI_SECONDS_TIME_UNIT = TimeUnit.MILLISECONDS;

    public void gracefulShutdown(ExecutorService service, Duration timeout) throws InterruptedException {
        service.shutdown();
        long timeout_in_unit_of_miliseconds = timeout.toMillis();
        if (!service.awaitTermination(timeout_in_unit_of_miliseconds, MILLI_SECONDS_TIME_UNIT)) {
            service.shutdownNow();
            if (!service.awaitTermination(timeout_in_unit_of_miliseconds, MILLI_SECONDS_TIME_UNIT)) {
                logger.error("The executor service did not terminate.");
            }
        }
    }
}

