/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class HodorThreadFactory
implements ThreadFactory {
    private static final AtomicLong THREAD_NUMBER = new AtomicLong(1L);
    private static final ThreadGroup THREAD_GROUP = new ThreadGroup("hodor");
    private final boolean daemon;
    private final String namePrefix;

    private HodorThreadFactory(String namePrefix, boolean daemon) {
        this.namePrefix = namePrefix;
        this.daemon = daemon;
    }

    public static ThreadFactory create(String namePrefix, boolean daemon) {
        return new HodorThreadFactory(namePrefix, daemon);
    }

    public String getName() {
        return this.namePrefix;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(THREAD_GROUP, runnable, THREAD_GROUP.getName() + "-" + this.namePrefix + "-" + THREAD_NUMBER.getAndIncrement());
        thread.setDaemon(this.daemon);
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }
}

