/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.connect;

import java.util.ArrayList;
import org.dromara.hodor.common.Host;
import org.dromara.hodor.common.utils.Utils;

public class ConnectStringParser {
    private static final int DEFAULT_PORT = 80;
    private final String protocolName;
    private final String rootName;
    private final ArrayList<Host> hosts = new ArrayList();

    public ConnectStringParser(String connectString) {
        String[] hostsList;
        Utils.Assert.notBlank(connectString, "hodor client connect string must be not blank.", new Object[0]);
        int index = connectString.indexOf("://");
        if (index >= 0) {
            this.protocolName = connectString.substring(0, index);
            connectString = connectString.substring(index + 3);
        } else {
            this.protocolName = null;
        }
        int off = connectString.indexOf(47);
        if (off >= 0) {
            String rootName = connectString.substring(off + 1);
            this.rootName = rootName.length() == 1 ? null : rootName;
            connectString = connectString.substring(0, off);
        } else {
            this.rootName = null;
        }
        for (String host : hostsList = connectString.split(",")) {
            int port = 80;
            int pidx = host.lastIndexOf(58);
            if (pidx >= 0) {
                if (pidx < host.length() - 1) {
                    port = Integer.parseInt(host.substring(pidx + 1));
                }
                host = host.substring(0, pidx);
            }
            this.hosts.add(Host.builder().ip(host).port(port).build());
        }
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public String getRootName() {
        return this.rootName;
    }

    public ArrayList<Host> getHosts() {
        return this.hosts;
    }
}

