/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.connect;

import java.util.function.Function;
import org.dromara.hodor.common.Host;
import org.dromara.hodor.common.connect.ConnectStringParser;
import org.dromara.hodor.common.utils.StringUtils;

public class TrySender {
    private static volatile String lastConnectUrl = null;
    private static final String URL_FORMAT = "{}://{}/{}";

    public static <R> R send(ConnectStringParser parser, Function<String, R> function) throws Exception {
        return TrySender.send(parser, function, e -> e);
    }

    public static <R> R send(ConnectStringParser parser, Function<String, R> function, Function<Exception, Exception> supplier) throws Exception {
        Exception finallyException = null;
        if (lastConnectUrl != null) {
            try {
                return function.apply(lastConnectUrl);
            }
            catch (Exception e) {
                finallyException = e;
            }
        }
        for (Host host : parser.getHosts()) {
            try {
                String url = StringUtils.format(URL_FORMAT, parser.getProtocolName(), host.getEndpoint(), parser.getRootName());
                R result = function.apply(url);
                lastConnectUrl = url;
                return result;
            }
            catch (Exception e) {
                finallyException = e;
            }
        }
        lastConnectUrl = null;
        if (finallyException != null) {
            throw supplier.apply(finallyException);
        }
        return null;
    }
}

