/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.dag;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.dromara.hodor.common.IdGenerator;
import org.dromara.hodor.common.dag.DagException;
import org.dromara.hodor.common.dag.Node;
import org.dromara.hodor.common.dag.NodeLayer;
import org.dromara.hodor.common.dag.Status;
import org.dromara.hodor.common.utils.StringUtils;

public class Dag {
    private final String name;
    private final List<Node> nodes = new ArrayList<Node>();
    private final List<NodeLayer> nodeLayers = new ArrayList<NodeLayer>();
    private Long id;
    private int layerSize;
    private Status status = Status.READY;
    private String schedulerName;

    public Dag(String name) {
        Objects.requireNonNull(name, "The name of the Dag can't be null");
        this.name = name;
        this.id = IdGenerator.defaultGenerator().nextId();
    }

    public void addNode(Node node) {
        assert (node.getDag() == this);
        this.nodes.add(node);
    }

    public void start() {
        assert (this.status == Status.READY);
        this.changeStatus(Status.RUNNING);
        for (Node node : this.nodes) {
            node.runIfAllowed();
        }
        this.updateDagStatus();
    }

    public void kill() {
        if (this.status.isTerminal() || this.status == Status.KILLING) {
            return;
        }
        this.changeStatus(Status.KILLING);
        for (Node node : this.nodes) {
            node.kill();
        }
        this.updateDagStatus();
    }

    public void updateDagStatus() {
        boolean failed = false;
        for (Node node : this.nodes) {
            Status nodeStatus = node.getStatus();
            if (!nodeStatus.isTerminal()) {
                return;
            }
            if (nodeStatus != Status.FAILURE) continue;
            failed = true;
        }
        this.updateDagStatusInternal(failed);
    }

    private void updateDagStatusInternal(boolean failed) {
        if (this.status == Status.KILLING) {
            this.changeStatus(Status.KILLED);
        } else if (failed) {
            this.changeStatus(Status.FAILURE);
        } else {
            this.changeStatus(Status.SUCCESS);
        }
    }

    public void changeStatus(Status status) {
        this.status = status;
    }

    public String toString() {
        return String.format("dag (%s), id (%s), status (%s)", new Object[]{this.name, this.id, this.status});
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public Node getNode(String groupName, String nodeName) {
        return this.getNodes().stream().filter(node -> node.getGroupName().equals(groupName) && node.getNodeName().equals(nodeName)).findFirst().orElseThrow(() -> new IllegalArgumentException(StringUtils.format("node {}#{} is illegal node name.", groupName, nodeName)));
    }

    public Map<Integer, List<Node>> getLayerNodeMap() {
        return this.getNodes().stream().collect(Collectors.groupingBy(Node::getLayer, TreeMap::new, Collectors.toList()));
    }

    public void buildNodeLayers() {
        Map<Integer, List<Node>> levelNodes = this.getLayerNodeMap();
        levelNodes.forEach((layer, nodes) -> {
            NodeLayer nodeLayer = new NodeLayer();
            nodeLayer.setLayer((int)layer);
            nodeLayer.setNodes((List<Node>)nodes);
            this.nodeLayers.add(nodeLayer);
        });
        this.layerSize = this.nodeLayers.size();
    }

    public List<NodeLayer> getNodeLayers() {
        return this.nodeLayers;
    }

    public NodeLayer getLayer(int layer) {
        List<NodeLayer> nodeLayers = this.getNodeLayers();
        if (layer - nodeLayers.size() >= 0) {
            throw new DagException("layer is illegal, exceed max layer.");
        }
        return nodeLayers.get(layer);
    }

    public Optional<NodeLayer> getFirstLayer() {
        List<NodeLayer> nodeLayers = this.getNodeLayers();
        return nodeLayers.stream().findFirst();
    }

    public boolean isLastLayer(int layer) {
        return this.layerSize == layer + 1;
    }

    public Long getDagId() {
        return this.id;
    }

    public void setDagId(Long id) {
        this.id = id;
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public int getLayerSize() {
        return this.layerSize;
    }
}

