/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.dag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dromara.hodor.common.dag.Dag;
import org.dromara.hodor.common.dag.DagException;
import org.dromara.hodor.common.dag.Node;
import org.dromara.hodor.common.utils.StringUtils;

public class DagBuilder {
    private final Dag dag;
    private final Map<String, Node> nameToNodeMap = new HashMap<String, Node>();
    private boolean isBuilt = false;

    public DagBuilder(String name) {
        Objects.requireNonNull(name, "The name of the DagBuilder can't be null");
        this.dag = new Dag(name);
    }

    public DagBuilder(String groupName, String jobName) {
        Objects.requireNonNull(groupName, "The groupName of the DagBuilder can't be null");
        Objects.requireNonNull(jobName, "The jobName of the DagBuilder can't be null");
        this.dag = new Dag(StringUtils.format("{}#{}", groupName, jobName));
    }

    public Node createNode(String groupName, String name, Object rawData) {
        this.checkIsBuilt();
        if (this.nameToNodeMap.get(name) != null) {
            throw new DagException(String.format("Node names in %s need to be unique. The name (%s) already exists.", this, name));
        }
        Node node = new Node(groupName, name, rawData, this.dag);
        this.nameToNodeMap.put(name, node);
        return node;
    }

    private void checkIsBuilt() {
        if (this.isBuilt) {
            String msg = String.format("The DAG (%s) is built already. Can't create new nodes.", this);
            throw new DagException(msg);
        }
    }

    public void addParentNode(String childNodeKeyName, String parentNodeKeyName) {
        this.checkIsBuilt();
        Node child = this.nameToNodeMap.get(childNodeKeyName);
        if (child == null) {
            throw new DagException(String.format("Unknown child node (%s). Did you create the node?", childNodeKeyName));
        }
        Node parent = this.nameToNodeMap.get(parentNodeKeyName);
        if (parent == null) {
            throw new DagException(String.format("Unknown parent node (%s). Did you create the node?", parentNodeKeyName));
        }
        if (child.getLayer() < parent.getLayer() + 1) {
            child.setLayer(parent.getLayer() + 1);
            this.adjustChildNodeLayer(child);
        }
        child.addParent(parent);
    }

    private void adjustChildNodeLayer(Node child) {
        for (Node childChild : child.getChildren()) {
            if (child.getLayer() >= childChild.getLayer()) {
                childChild.setLayer(child.getLayer() + 1);
            }
            this.adjustChildNodeLayer(childChild);
        }
    }

    public Dag build() {
        this.checkIsBuilt();
        this.checkCircularDependencies();
        this.dag.buildNodeLayers();
        this.isBuilt = true;
        return this.dag;
    }

    private void checkCircularDependencies() {
        class CircularDependencyChecker {
            private final Set<Node> toVisit;
            private final Set<Node> finished;
            private final Set<Node> ongoing;
            private final List<Node> sampleCircularNodes;

            CircularDependencyChecker() {
                this.toVisit = new HashSet(DagBuilder.this.nameToNodeMap.values());
                this.finished = new HashSet<Node>();
                this.ongoing = new HashSet<Node>();
                this.sampleCircularNodes = new ArrayList<Node>();
            }

            private void check() {
                while (!this.toVisit.isEmpty()) {
                    Node node = this.removeOneNodeFromToVisitSet();
                    if (!this.checkNode(node)) continue;
                    String msg = String.format("Circular dependency detected. Sample: %s", this.sampleCircularNodes);
                    throw new DagException(msg);
                }
            }

            private Node removeOneNodeFromToVisitSet() {
                Iterator<Node> iterator = this.toVisit.iterator();
                Node node = iterator.next();
                iterator.remove();
                return node;
            }

            private boolean checkNode(Node node) {
                if (this.finished.contains(node)) {
                    return false;
                }
                if (this.ongoing.contains(node)) {
                    this.sampleCircularNodes.add(node);
                    return true;
                }
                this.toVisit.remove(node);
                this.ongoing.add(node);
                for (Node parent : node.getParents()) {
                    if (!this.checkNode(parent)) continue;
                    this.sampleCircularNodes.add(node);
                    return true;
                }
                this.ongoing.remove(node);
                this.finished.add(node);
                return false;
            }
        }
        CircularDependencyChecker checker = new CircularDependencyChecker();
        checker.check();
    }

    public String toString() {
        return String.format("DagBuilder (%s)", this.dag.getName());
    }
}

