/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.dag;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.dromara.com.google.common.annotations.VisibleForTesting;
import org.dromara.hodor.common.IdGenerator;
import org.dromara.hodor.common.dag.Dag;
import org.dromara.hodor.common.dag.NodeLayer;
import org.dromara.hodor.common.dag.Status;

public class Node {
    private Long id;
    private final String groupName;
    private final String nodeName;
    private Object rawData;
    private final List<Node> parents = new ArrayList<Node>();
    private final List<Node> children = new ArrayList<Node>();
    private Status status = Status.READY;
    private final Dag dag;
    private int layer = 0;

    public Node(String groupName, String nodeName, Object rawData, Dag dag) {
        Objects.requireNonNull(groupName, "The groupName of the node can't be null");
        Objects.requireNonNull(nodeName, "The nodeName of the node can't be null");
        Objects.requireNonNull(dag, "The dag of the node can't be null");
        Objects.requireNonNull(rawData, "The rawData of the node can't be null");
        this.groupName = groupName;
        this.nodeName = nodeName;
        this.dag = dag;
        this.rawData = rawData;
        this.id = IdGenerator.defaultGenerator().nextId();
        dag.addNode(this);
    }

    public Dag getDag() {
        return this.dag;
    }

    public Long getNodeId() {
        return this.id;
    }

    public void setNodeId(Long id) {
        this.id = id;
    }

    public Object getRawData() {
        return this.rawData;
    }

    public void setRawData(Object rawData) {
        this.rawData = rawData;
    }

    void addParent(Node node) {
        this.parents.add(node);
        node.addChild(this);
    }

    private void addChild(Node node) {
        this.children.add(node);
    }

    boolean hasParent() {
        return !this.parents.isEmpty();
    }

    public boolean isReady() {
        if (this.status != Status.READY) {
            return false;
        }
        for (Node parent : this.parents) {
            if (parent.status.isSuccessEffectively()) continue;
            return false;
        }
        return true;
    }

    public void markSuccess() {
        this.assertRunningOrKilling();
        this.changeStatus(Status.SUCCESS);
        NodeLayer layer = this.dag.getLayer(this.getLayer());
        if (layer.getRunningNodeNums() == 1) {
            layer.setStatus(Status.SUCCESS);
        }
        layer.setRunningNodeNums(layer.getRunningNodeNums() - 1);
    }

    public void runIfAllowed() {
        if (this.isReady()) {
            this.changeStatus(Status.RUNNING);
        }
    }

    public void markFailed() {
        this.assertRunningOrKilling();
        this.changeStatus(Status.FAILURE);
        for (Node child : this.children) {
            child.cancel();
        }
        this.dag.updateDagStatus();
    }

    public void cancel() {
        assert (this.status.isPreRunState());
        if (this.status != Status.DISABLED) {
            this.changeStatus(Status.CANCELED);
        }
        for (Node node : this.children) {
            node.cancel();
        }
    }

    private void assertRunningOrKilling() {
        assert (this.status == Status.RUNNING || this.status == Status.KILLING);
    }

    public void changeStatus(Status status) {
        this.status = status;
    }

    public void kill() {
        assert (this.dag.getStatus() == Status.KILLING);
        if (this.status == Status.READY || this.status == Status.BLOCKED) {
            this.changeStatus(Status.CANCELED);
        } else if (this.status == Status.RUNNING) {
            this.changeStatus(Status.KILLING);
        }
    }

    public void markKilled() {
        assert (this.status == Status.KILLING);
        this.changeStatus(Status.KILLED);
        this.dag.updateDagStatus();
    }

    public String toString() {
        return String.format("Node (%s_%s) id (%s) status (%s) layer (%s) in [%s]", new Object[]{this.groupName, this.nodeName, this.id, this.status, this.layer, this.dag});
    }

    public Status getStatus() {
        return this.status;
    }

    @VisibleForTesting
    public void setStatus(Status status) {
        this.status = status;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public NodeLayer getCurrentNodeLayer() {
        return this.dag.getLayer(this.layer);
    }

    @VisibleForTesting
    public List<Node> getChildren() {
        return this.children;
    }

    @VisibleForTesting
    public List<Node> getParents() {
        return this.parents;
    }

    public NodeLayer getNodeLayer() {
        return this.getDag().getLayer(this.layer);
    }
}

