/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.dag;

import org.dromara.com.google.common.collect.ImmutableSet;

public enum Status {
    READY,
    DISABLED,
    BLOCKED,
    RUNNING,
    SUCCESS,
    FAILURE,
    CANCELED,
    KILLING,
    KILLED;

    static final ImmutableSet<Status> RUNNING_STATES;
    static final ImmutableSet<Status> TERMINAL_STATES;
    private static final ImmutableSet<Status> EFFECTIVE_SUCCESS_STATES;
    private static final ImmutableSet<Status> PRE_RUN_STATES;

    public boolean isRunning() {
        return RUNNING_STATES.contains((Object)this);
    }

    public boolean isTerminal() {
        return TERMINAL_STATES.contains((Object)this);
    }

    public boolean isSuccessEffectively() {
        return EFFECTIVE_SUCCESS_STATES.contains((Object)this);
    }

    public boolean isPreRunState() {
        return PRE_RUN_STATES.contains((Object)this);
    }

    static {
        RUNNING_STATES = ImmutableSet.of(RUNNING);
        TERMINAL_STATES = ImmutableSet.of(DISABLED, SUCCESS, FAILURE, CANCELED, KILLED);
        EFFECTIVE_SUCCESS_STATES = ImmutableSet.of(DISABLED, SUCCESS);
        PRE_RUN_STATES = ImmutableSet.of(DISABLED, READY, BLOCKED);
    }
}

