/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.disruptor;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.hodor.common.concurrent.HodorThreadFactory;
import org.dromara.hodor.common.disruptor.QueueConsumer;
import org.dromara.hodor.common.disruptor.QueueConsumerFactory;
import org.dromara.hodor.common.disruptor.QueueEventFactory;
import org.dromara.hodor.common.disruptor.QueueProvider;

public class QueueProviderManager<T> {
    private final Integer size;
    private QueueConsumerFactory<T> queueConsumerFactory;
    private ExecutorService executor;
    private QueueProvider<T> provider;
    private Integer threadSize;
    private Integer consumerSize;

    public QueueProviderManager(QueueConsumerFactory<T> queueConsumerFactory) {
        this(queueConsumerFactory, 16384);
    }

    public QueueProviderManager(QueueConsumerFactory<T> queueConsumerFactory, int ringBufferSize) {
        this(queueConsumerFactory, Runtime.getRuntime().availableProcessors() << 1, Runtime.getRuntime().availableProcessors() << 1, ringBufferSize);
    }

    public QueueProviderManager(QueueConsumerFactory<T> queueConsumerFactory, int exeThreadSize, int consumerSize, int ringBufferSize) {
        this.queueConsumerFactory = queueConsumerFactory;
        this.threadSize = exeThreadSize;
        this.size = ringBufferSize;
        this.consumerSize = consumerSize;
        this.executor = new ThreadPoolExecutor(this.threadSize, this.threadSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), HodorThreadFactory.create("disruptor_queue_exe-" + queueConsumerFactory.fixName(), false), new ThreadPoolExecutor.AbortPolicy());
    }

    public QueueProviderManager(QueueConsumerFactory<T> queueConsumerFactory, ExecutorService executor, int consumerSize, int ringBufferSize) {
        this.queueConsumerFactory = queueConsumerFactory;
        this.size = ringBufferSize;
        this.consumerSize = consumerSize;
        this.executor = executor;
    }

    public void start() {
        QueueEventFactory factory = new QueueEventFactory();
        Disruptor<Object> disruptor = new Disruptor<Object>(factory, (int)this.size, HodorThreadFactory.create("disruptor_queue_consumer-" + this.queueConsumerFactory.fixName(), false), ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        QueueConsumer[] consumers = new QueueConsumer[this.consumerSize.intValue()];
        for (int i = 0; i < this.consumerSize; ++i) {
            consumers[i] = new QueueConsumer<T>(this.executor, this.queueConsumerFactory);
        }
        disruptor.handleEventsWithWorkerPool(consumers);
        disruptor.setDefaultExceptionHandler(new IgnoreExceptionHandler());
        disruptor.start();
        RingBuffer buffer = disruptor.getRingBuffer();
        this.provider = new QueueProvider(buffer);
    }

    public QueueProvider<T> getProvider() {
        return this.provider;
    }
}

