/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.event;

import java.util.Set;
import org.dromara.hodor.common.event.AbstractEventPublisher;
import org.dromara.hodor.common.event.Event;
import org.dromara.hodor.common.event.HodorEventListener;
import org.dromara.hodor.common.executor.HodorExecutor;
import org.dromara.hodor.common.executor.HodorExecutorFactory;
import org.dromara.hodor.common.executor.HodorRunnable;

public abstract class AbstractAsyncEventPublisher<V>
extends AbstractEventPublisher<V> {
    private final HodorExecutor eventExecutor;

    public AbstractAsyncEventPublisher() {
        int threadSize = Runtime.getRuntime().availableProcessors() * 2;
        this.eventExecutor = HodorExecutorFactory.createDefaultExecutor("event-exec", threadSize, true);
    }

    @Override
    public void publish(final Event<V> event) {
        Set listenerSet = this.getListeners(event.getEventType());
        for (final HodorEventListener listener : listenerSet) {
            this.eventExecutor.serialExecute(new HodorRunnable(){

                @Override
                public void execute() {
                    listener.onEvent(event);
                }
            });
        }
    }

    public void parallelPublish(final Event<V> event) {
        Set listenerSet = this.getListeners(event.getEventType());
        for (final HodorEventListener listener : listenerSet) {
            this.eventExecutor.parallelExecute(new HodorRunnable(){

                @Override
                public void execute() {
                    listener.onEvent(event);
                }
            });
        }
    }
}

