/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.event;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.dromara.com.google.common.collect.Lists;
import org.dromara.com.google.common.collect.Maps;
import org.dromara.com.google.common.collect.Sets;
import org.dromara.hodor.common.event.Event;
import org.dromara.hodor.common.event.EventPublisher;
import org.dromara.hodor.common.event.HodorEventListener;

public abstract class AbstractEventPublisher<V>
implements EventPublisher<V> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<Object, Set<HodorEventListener<V>>> listeners = Maps.newConcurrentMap();
    private final Set<HodorEventListener<V>> EMPTY_LISTENERS = Sets.newConcurrentHashSet();

    public AbstractEventPublisher() {
        this.registryListener();
    }

    @Override
    public void addListener(HodorEventListener<V> listener) {
        this.addListener(listener, "DEFAULT");
    }

    @Override
    public void addListener(HodorEventListener<V> objectListener, Object eventType) {
        this.lock.lock();
        try {
            if (this.listeners.get(eventType) == null) {
                this.listeners.put(eventType, Sets.newCopyOnWriteArraySet(Lists.newArrayList(objectListener)));
            } else {
                this.listeners.get(eventType).add(objectListener);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Object eventType, HodorEventListener<V> objectListener) {
        this.lock.lock();
        try {
            Set<HodorEventListener<V>> listenerSet = this.listeners.get(eventType);
            if (listenerSet == null) {
                return;
            }
            listenerSet.remove(objectListener);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeListener(Object eventType) {
        this.lock.lock();
        try {
            this.listeners.remove(eventType);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void publish(Event<V> event) {
        Set<HodorEventListener<V>> listeners = this.getListeners(event.getEventType());
        for (HodorEventListener<V> listener : listeners) {
            listener.onEvent(event);
        }
    }

    @Override
    public void clearListener() {
        this.lock.lock();
        try {
            this.listeners.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Set<HodorEventListener<V>> getListeners(Object eventType) {
        if (this.listeners.get(eventType) == null) {
            return this.EMPTY_LISTENERS;
        }
        return this.listeners.get(eventType);
    }
}

