/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.executor;

import java.util.Optional;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.dromara.hodor.common.concurrent.HodorThreadFactory;
import org.dromara.hodor.common.executor.ExecutorInfo;
import org.dromara.hodor.common.executor.HodorRunnable;
import org.dromara.hodor.common.queue.CircleQueue;
import org.dromara.hodor.common.queue.RejectedEnqueueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HodorExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HodorExecutor.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicBoolean serialExecutable = new AtomicBoolean(false);
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final AtomicInteger rejectCount = new AtomicInteger(0);
    private final CircleQueue<HodorRunnable> serialQueue;
    private ThreadPoolExecutor executor;

    public HodorExecutor(int queueSize, ThreadPoolExecutor executor) {
        this.serialQueue = new CircleQueue(queueSize <= 0 ? 128 : queueSize);
        this.executor = executor;
        this.setRejectExecutionHandler(executor);
    }

    public HodorExecutor(ThreadPoolExecutor executor) {
        this.serialQueue = new CircleQueue(128);
        this.executor = executor;
        this.setRejectExecutionHandler(executor);
    }

    public void setRejectEnqueuePolicy(RejectedEnqueueHandler<HodorRunnable> handler) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.serialQueue.setRejectedEnqueueHandler(handler);
        }
        finally {
            lock.unlock();
        }
    }

    public void setExecutor(ThreadPoolExecutor executor) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.executor = executor;
            this.setRejectExecutionHandler(executor);
        }
        finally {
            lock.unlock();
        }
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public CircleQueue<HodorRunnable> getQueue() {
        return this.serialQueue;
    }

    public void serialExecute(HodorRunnable runnable) {
        this.lock.lock();
        try {
            this.offer(runnable);
            if (this.serialExecutable.compareAndSet(false, true)) {
                this.notifyNextTaskExecute();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void parallelExecute(HodorRunnable runnable) {
        this.lock.lock();
        try {
            this.executor.execute(runnable);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offer(HodorRunnable runnable) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.isShutdown()) {
                throw new IllegalStateException("Hodor executor has shutdown.");
            }
            boolean offered = this.serialQueue.offer(runnable);
            if (!offered) {
                log.warn("Queue offer false. Please check the job entry policy...");
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void setRejectExecutionHandler(ThreadPoolExecutor executor) {
        RejectedExecutionHandler rejectedExecutionHandler = executor.getRejectedExecutionHandler();
        executor.setRejectedExecutionHandler((r, pool) -> {
            this.rejectCount.incrementAndGet();
            rejectedExecutionHandler.rejectedExecution(r, pool);
        });
    }

    private void reset() {
        this.serialExecutable.compareAndSet(true, false);
    }

    private void notifyNextTaskExecute() {
        if (this.serialQueue.isEmpty()) {
            this.reset();
            return;
        }
        Optional.ofNullable(this.serialQueue.poll()).ifPresent(runnable -> this.executor.execute(() -> {
            try {
                runnable.run();
            }
            catch (Throwable unexpected) {
                log.error("Catch unexpected exception {}.", (Object)unexpected.getMessage(), (Object)unexpected);
            }
            finally {
                this.notifyNextTaskExecute();
            }
        }));
    }

    public boolean isShutdown() {
        return this.shutdown.get() && this.executor.isShutdown();
    }

    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            this.executor.shutdown();
        }
    }

    public ExecutorInfo getExecutorInfo() {
        return ExecutorInfo.builder().executorName(((HodorThreadFactory)this.executor.getThreadFactory()).getName()).circleQueueSize(this.serialQueue.size()).circleQueueCapacity(this.serialQueue.getCapacity()).queueSize(this.executor.getQueue().size()).queueCapacity(this.executor.getQueue().size() + this.executor.getQueue().remainingCapacity()).activeTaskCount(this.executor.getActiveCount()).waitTaskCount(this.executor.getQueue().size()).taskCount(this.executor.getTaskCount()).completeTaskCount(this.executor.getCompletedTaskCount()).largestPoolSize(this.executor.getLargestPoolSize()).currentThreadSize(this.executor.getPoolSize()).coreThreadSize(this.executor.getCorePoolSize()).maximumPoolSize(this.executor.getMaximumPoolSize()).rejectCount(this.rejectCount.get()).build();
    }
}

