/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hodor.common.executor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.hodor.common.concurrent.HodorThreadFactory;
import org.dromara.hodor.common.executor.HodorExecutor;
import org.dromara.hodor.common.executor.HodorRunnable;
import org.dromara.hodor.common.queue.AbortEnqueuePolicy;
import org.dromara.hodor.common.queue.AdjustThreadSizePolicy;
import org.dromara.hodor.common.queue.DiscardOldestElementPolicy;
import org.dromara.hodor.common.queue.ResizeQueuePolicy;

public class HodorExecutorFactory {
    private static final Map<String, ThreadPoolExecutor> threadPoolExecutorMap = new ConcurrentHashMap<String, ThreadPoolExecutor>(8);

    public static ThreadPoolExecutor createThreadPoolExecutor(String executorName, int threadSize, int poolSize, boolean coreThreadTimeOut) {
        return threadPoolExecutorMap.computeIfAbsent(executorName, k -> {
            ThreadFactory threadFactory = HodorThreadFactory.create(executorName, false);
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threadSize, threadSize, 3L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(poolSize), threadFactory);
            threadPoolExecutor.allowCoreThreadTimeOut(coreThreadTimeOut);
            return threadPoolExecutor;
        });
    }

    public static HodorExecutor createDefaultExecutor(String executorName, int threadSize, boolean coreThreadTimeOut) {
        return HodorExecutorFactory.createExecutor(executorName, threadSize, 500, coreThreadTimeOut, 0);
    }

    public static HodorExecutor createExecutor(String executorName, int threadSize, int poolSize, boolean coreThreadTimeOut, int taskStackingStrategy) {
        ThreadPoolExecutor threadPoolExecutor = HodorExecutorFactory.createThreadPoolExecutor(executorName, threadSize, poolSize, coreThreadTimeOut);
        HodorExecutor executor = new HodorExecutor(threadPoolExecutor);
        HodorExecutorFactory.setHodorExecutorStackingStrategy(taskStackingStrategy, executor);
        return executor;
    }

    private static void setHodorExecutorStackingStrategy(int taskStackingStrategy, HodorExecutor executor) {
        if (taskStackingStrategy == 0) {
            executor.setRejectEnqueuePolicy(new DiscardOldestElementPolicy<HodorRunnable>());
            return;
        }
        if (taskStackingStrategy == 1) {
            executor.setRejectEnqueuePolicy(new AbortEnqueuePolicy<HodorRunnable>());
            return;
        }
        if (taskStackingStrategy == 2) {
            executor.setRejectEnqueuePolicy(new ResizeQueuePolicy<HodorRunnable>());
            return;
        }
        if (taskStackingStrategy == 3) {
            executor.setRejectEnqueuePolicy(new AdjustThreadSizePolicy<HodorRunnable>(executor.getExecutor()));
            return;
        }
        throw new UnsupportedOperationException("Unsupported taskStackingStrategy " + taskStackingStrategy);
    }
}

